/*
  name: initcanvas.cpp

  This file is part of ARCS - Augmented Reality Component System,
  written by Jean-Yves Didier, Vincent Le Ligeour and Yoann Petit
  for IBISC Laboratory (http://www.ibisc.univ-evry.fr)

  Copyright (C) 2004 Universit d'Evry-Val d'Essonne

  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.


  Please send bugreports  with examples or suggestions to
  didier__at__iup.univ-evry.fr
*/


//#include "metabase.h"
#include "initcanvas.h"
#include <qpen.h>


InitCanvas::InitCanvas(MetaInit* mi, NodeItem* ni, bool post)
    :  QCanvasEllipse( ni->canvas() )
{
     myInit = mi;
     myNode = ni;
//-->     myConnect = post; 
     setZ(3);
     setSize(19,19);
     //on defini la couleur de rond
     if ( post ) //post connexion
	  setBrush( QColor(215,85,85));
     else
	  setBrush( QColor(80,200,130));
     setPen(QPen(QColor(0,0,0),4,Qt::SolidLine));
     //recup le node slot correspondant
     //cout<<mi->getSlot().ascii()<<endl;

     //on met le initWire a null pour eviter une segf lors de la cration et du move
     initWire = NULL;

     move(ni->x()-20,ni->y()+5);
     initWire = new QCanvasLine( ni->canvas() );
     initWire->setBrush( QColor(0,0,0) );
     initWire->setPoints(int(ni->x()-20),int(ni->y()+5),int(ni->x()),int(ni->y()+5));
     initWire->setZ(2);
     postInit = post;
     initWire->show();
}

InitCanvas::~InitCanvas()
{
     delete initWire;
     delete myInit;
}

void InitCanvas::moveBy(double dx, double dy)
{
     QCanvasEllipse::moveBy( dx, dy);
     if (initWire != NULL)
	  initWire->moveBy( dx, dy);
}


