/*
  name: initvaluedialog.h

  This file is part of ARCS - Augmented Reality Component System,
  written by Jean-Yves Didier, Vincent Le Ligeour and Yoann Petit
  for IBISC Laboratory (http://www.ibisc.univ-evry.fr)

  Copyright (C) 2004 Universit d'Evry-Val d'Essonne

  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.


  Please send bugreports  with examples or suggestions to
  didier__at__iup.univ-evry.fr
*/


#ifndef __INITVALUEDIALOG_H__
#define __INITVALUEDIALOG_H__

#include <metalibrary/metalibrary.h>

#include <qdialog.h>
#include <qlistview.h>
#include <qlineedit.h>
#include <qpushbutton.h>
#include <qradiobutton.h> 
#include <qcombobox.h>
#include <qvbox.h>

#include "sheetview.h"


class InitValueDialog : public QDialog 
{
Q_OBJECT
public:
      InitValueDialog( QWidget *parent, const char *name, QString slot, QString value=0, bool postInit=false);

private:
      QPushButton *ok, *cancel;

public :
     QString getValue() { return value; }
     bool isPostInit() { return post->isChecked(); }
     bool isDefine() { return define; }


public slots:
     void acceptObject();
     void setPostTrue();
     void setPostFalse();
     void setRadioTrue();
     void setRadioFalse();
     
private:
     void fillDefines(QVBox* box,QString s);

      QLineEdit *data;
      QRadioButton *post;
      QRadioButton *pre;
      QRadioButton *t;
      QRadioButton *f;
      QComboBox *cb;
      QComboBox *defineCombo;
      QString type;
      QString value;
      bool define;
 
};


#endif  // __INITVALUEDIALOG_H__
