/*
  name: iocanvas.h

  This file is part of ARCS - Augmented Reality Component System,
  written by Jean-Yves Didier, Vincent Le Ligeour and Yoann Petit
  for IBISC Laboratory (http://www.ibisc.univ-evry.fr)

  Copyright (C) 2004 Universit d'Evry-Val d'Essonne

  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.


  Please send bugreports  with examples or suggestions to
  didier__at__iup.univ-evry.fr
*/


#ifndef __IOCANVAS_H__
#define __IOCANVAS_H__

/*! \file transitioncanvas.h
 * \author Jean-Yves Didier
 * \date 18 Jan 2006
 * 
 * File describes IOCanvas
 */

#include <metalibrary/metabase.h>
#include "wirecanvas.h"

/*! \brief IOCanvas description
 * 
 * It represents a MetaIO object for macro-blocks..
 */
class IOCanvas : public QCanvasPolygon
{
public:
     /*! \brief IOCanvas constructor.
      *  \param *mi MetaIO of the IOCanvas.
      *  \param *ni NodeItem where is connected the IOCanvas.
      */
     IOCanvas( MetaIO* mi, NodeItem* ni);
     ~IOCanvas();

     /*! \brief Returns the RTTI of the IOCanvas.
      *  \return RTTI of the IOCanvas.
      */
     int rtti() const { return RTTI_IOCANVAS; }

     void moveBy(double dx, double dy);

     /*! \brief Returns the MetaInit of the InitCanvas.
      *  \return MetaInit of the InitCanvas.
      */
     MetaIO* getMetaIO(){return myIO;}
     NodeItem* getNode(){return myNode;}



private:
     MetaIO* myIO; //!< InitCanvas's MetaInit
     NodeItem* myNode; //!< InitCanvas's NodeItem
     QCanvasLine* line;
     QCanvasText* text;
};

#endif //__IOCANVAS_H__

