/*
  name: objectcanvas.cpp

  This file is part of ARCS - Augmented Reality Component System,
  written by Jean-Yves Didier, Vincent Le Ligeour and Yoann Petit
  for IBISC Laboratory (http://www.ibisc.univ-evry.fr)

  Copyright (C) 2004 Universit d'Evry-Val d'Essonne

  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.


  Please send bugreports  with examples or suggestions to
  didier__at__iup.univ-evry.fr
*/


#include "objectcanvas.h"
//#include "metabase.h"
//#include "wirecanvas.h"
//#include "sheetview.h"
#include <qstrlist.h>
//#include <qptrlist.h>
//#include "addwiredialog.h"
#include <qfont.h>
#include <vector>

using namespace std;

ObjectCanvas::ObjectCanvas(MetaObject* mo, int x, int y, int width, int height, QCanvas* canvas /*-->,MetaLibrary* ml*/) :
			   QCanvasRectangle(x,y,width,height,canvas)
{
     
     myObject = mo;
     posSlt = height;
     posSgn = height;
     QFont fntTitle("Times",20,QFont::Black);
     QFontMetrics fntmTitle(fntTitle);
     titlelabel = new QCanvasText( MetaObject::stripNamespace(mo->getID()), canvas);
     titlelabel->move(x+5,y+10);
     titlelabel->setColor( QColor( 40, 80, 170));
     titlelabel->setFont( fntTitle );
     titlelabel->show();
  
     QFont fntUnder("Times",14);
     QFontMetrics fntmUnder(fntTitle);
     underlabel = new QCanvasText(mo->getClassName(), canvas);
     if (mo->isBlock())
	  underlabel->setColor(QColor( 200, 0,0));
     underlabel->move(x+5,y+height+10);
     underlabel->setFont( fntUnder );
     underlabel->show();
     
     myItem.append(underlabel);
     myItem.append(titlelabel);

     /*
     NodeItem* myNode;
     maxSltLength = 0;
     for (uint i=0; i < slt.count(); i++ )
     {
	  myNode = new NodeItem( this, x-5 ,y+40+(20*i),slt.at(i), true); 
	  if (myNode->getWidth() > maxSltLength)
	       maxSltLength = myNode->getWidth();
	  myItem.append(myNode);
	  dNodeSlot.insert(slt.at(i), myNode);
     } 

     maxSgnLength = 0;
     for (uint i=0; i < sgn.count(); i++ )
     {
	  myNode = new NodeItem( this, x+width,y+40+(20*i),sgn.at(i), false);
	  if (myNode->getWidth() > maxSgnLength )
	       maxSgnLength = myNode->getWidth();
	  myItem.append(myNode);
	  dNodeSignal.insert(sgn.at(i), myNode);
     } 

     maxWidth = maxSltLength + maxSgnLength + 20;
     setSize(maxWidth,maxHeight);
     
     //Bouger l'emplacement des nodeitem des signaux
     QDictIterator<NodeItem> it( dNodeSignal );
     for( ; it.current(); ++it )
	  (it.current())->moveBy(maxWidth - width,0);
     l=maxWidth;
     h=maxHeight;
     */

     
     maxWidth = max ( ( fntmTitle.width(MetaObject::stripNamespace(mo->getID())) +10 ), fntmUnder.width(mo->getClassName()));

     maxHeight = height;  
     maxSltLength = maxWidth/2;
     maxSgnLength = maxWidth/2;

     setObjectPersistence(false);
     setSize(maxWidth,maxHeight);

     update();
     
     dNodeSignal.setAutoDelete(true);
     dNodeSlot.setAutoDelete(true);
     dIO.setAutoDelete(true);
     dWireSignal.setAutoDelete(true);
     dInit.setAutoDelete(true);
}

ObjectCanvas::~ObjectCanvas()
{
     delete titlelabel;
     delete underlabel;
} 

void ObjectCanvas::addNode(QString nodeID, bool slot)
{
    // supp un node si pas utilis
    //cout<<"Ajout du node : "<<nodeID.ascii()<<slot<<endl;
    double oldWidth = boundingRect().width(); 

    if ( slot ) {
	 if ( !dNodeSlot[nodeID] ) {
	      NodeItem* myNode = new NodeItem( this, int(x()-5) ,int(y() + posSlt), nodeID, true); 
	      posSlt += 20; 
	      if (myNode->getWidth() > maxSltLength)
		   maxSltLength = myNode->getWidth();
	      myItem.append(myNode);
	      dNodeSlot.insert(nodeID, myNode);
	 }
     } 
    else {
	 if ( !dNodeSignal[nodeID] ) {
	      NodeItem* myNode = new NodeItem( this, int(x() + width()) ,int(y() + posSgn), nodeID, false); 
	      posSgn += 20; 
	      if (myNode->getWidth() > maxSgnLength) {
		   maxSgnLength = myNode->getWidth();
		   myNode->move( (maxSgnLength + maxSltLength + x()),myNode->y());
	      }
	      myItem.append(myNode);
	      dNodeSignal.insert(nodeID, myNode);
	 }
    }
    
    //dfinition de la nouvelle taille de l'objet
    maxWidth = maxSltLength + maxSgnLength + 20 ;
    maxHeight = max(posSlt,posSgn);
    
    //repositionner tous les wires et nodes en signal...
    if ( dNodeSignal.count() > 0)
    {
	 QDictIterator<NodeItem> it( dNodeSignal );
	 for( ; it.current(); ++it )
	      it.current()->move((x() + maxWidth),(it.current())->y()); 
    }
    
    if ( dWireSignal.count() > 0)
    {
	 QDictIterator<WireCanvas> iteSgn( dWireSignal );
	 for( ; iteSgn.current(); ++iteSgn ) 
	      (iteSgn.current())->setFromPoint( int( maxWidth - width() ),0);
    }

    setSize(maxWidth,maxHeight);
    double currentWidth = boundingRect().width(); 



    if ( dIO.count() > 0)
    {
	 QDictIterator<IOCanvas> iteIO( dIO );
	 for ( ; iteIO.current(); ++iteIO )
	      if ( iteIO.current()->getNode()->x() > x())
		   iteIO.current()->moveBy(currentWidth-oldWidth,0);
    }

    
    
    //Dplacement du nom de la classe
    underlabel->move(x()+5,y()+maxHeight+10);
 
    update();
}


void ObjectCanvas::moveBy(double dx, double dy)
{
     QCanvasRectangle::moveBy(dx, dy);
    
     for (uint i=0; i < myItem.count(); i++)
     {
	  (myItem.at(i))->moveBy(dx,dy);
	  //(myItem.at(i))->setZ(z()+1);
     }
     // Parcourir les deux dictionnaires pour bouger aussi les wirecanvas associs

     if (dWireSignal.count())
     {
	  QDictIterator<WireCanvas> iteSgn( dWireSignal );
	  for( ; iteSgn.current(); ++iteSgn ) 
	       (iteSgn.current())->setFromPoint( int(dx), int(dy));
     }
     
     if (dWireSlot.count())
     {
	  QDictIterator<WireCanvas> iteSlt( dWireSlot );
	  for( ; iteSlt.current(); ++iteSlt ) 
	       (iteSlt.current())->setToPoint( int(dx), int(dy));
     }
     
     if (dInit.count())
     {
	  QDictIterator<InitCanvas> iteInit( dInit );
	  for( ; iteInit.current(); ++iteInit )
	       (iteInit.current())->moveBy( int(dx), int(dy));
     }	  


     if (dIO.count())
     {
	  QDictIterator<IOCanvas> iteIO(dIO);
	  for( ; iteIO.current(); ++iteIO )
	       (iteIO.current())->moveBy( int(dx), int(dy));
     }
}

/*
void ObjectCanvas::setZ(double z)
{
     QCanvasRectangle::setZ(z);

     for (uint i=0; i < myItem.count(); i++)
     {
	  //cout<<z<<endl;
	  (myItem.at(i))->setZ(z+1);
     }
}
*/


void ObjectCanvas::registerWire(WireCanvas* wc)
{
     MetaWire* mw = wc->getMetaWire();
     if (mw->getSender() == myObject->getID() )
	  dWireSignal.insert(mw->getSignal(), wc);

     if (mw->getReciever() == myObject->getID() )
	  dWireSlot.insert(mw->getSlot(), wc);
}

void ObjectCanvas::registerInit(InitCanvas* ic)
{
     MetaInit* mi = ic->getMetaInit();
     dInit.insert(mi->getSlot(), ic);
}


void ObjectCanvas::delWire(WireCanvas* wc)
{
     QDictIterator<WireCanvas> it(dWireSlot);
     vector<WireCanvas*> vwc;
     
     //cout << "Calling ObjectCanvas::delWire()" << endl;
     //cout << "This is object " << myObject->getID().ascii() << endl;

     do
     {
	  if (it.current() == wc)
	  {
	       QString key = it.currentKey();
	       WireCanvas* wcc = NULL;
	       do
	       {
		    wcc = dWireSlot.take(key);
		    if ((wcc != wc)&&(wcc != NULL))
			 vwc.push_back(wcc);
	       } while ( wcc != NULL );
	       for (unsigned int i=0; i < vwc.size(); i++)
		    dWireSlot.insert(key, vwc[i]);
	       break;
	  }
	  ++it; 
     } while ( it.current());
     
     vwc.clear();

     QDictIterator<WireCanvas> it2(dWireSignal);
     do
     {
	  if (it2.current() == wc)
	  {
	       QString key = it2.currentKey();
	       WireCanvas* wcc = NULL;
	       do
	       {
		    wcc = dWireSignal.take(key);		    
		    if ((wcc != wc)&&(wcc != NULL))
			 vwc.push_back(wcc);
	       } while ( wcc != NULL );
	       for (unsigned int i=0; i < vwc.size(); i++)
		    dWireSignal.insert(key, vwc[i]);
	       break;
	  }
	  ++it2;
     } while( it2.current());

     //delete wc;
}


QPtrList<WireCanvas> ObjectCanvas::getWireSignal(QString id)
{
     QDictIterator<WireCanvas> dIteSgn( dWireSignal );
     QPtrList<WireCanvas> plWireSignal;
     for( ; dIteSgn.current(); ++dIteSgn ) {
	  if ( dIteSgn.currentKey() == id ) {
	       plWireSignal.append( dIteSgn.current() );
	       cout<<((dIteSgn.current())->getFromNode())->getNodeName().ascii()<<endl;
	       cout<<((dIteSgn.current())->getToNode())->getNodeName().ascii()<<endl;
	  }
     }
     return plWireSignal;
}


// on pourait simplifier en une seul fonction
QPtrList<WireCanvas> ObjectCanvas::getWireSlot(QString id)
{
     cout<<"getwireslot"<<endl;
     QDictIterator<WireCanvas> dIteSlt( dWireSlot );
     QPtrList<WireCanvas> plWireSlot;
     for( ; dIteSlt.current(); ++dIteSlt ) {
	  if ( dIteSlt.currentKey() == id ) {
	       plWireSlot.append( dIteSlt.current() );
	       cout<<((dIteSlt.current())->getFromNode())->getNodeName().ascii()<<endl;
	       cout<<((dIteSlt.current())->getToNode())->getNodeName().ascii()<<endl<<endl;
	  }
     }
     return plWireSlot;
}


void ObjectCanvas::setInit(MetaSheet *ms)
{
     QDictIterator<InitCanvas> it = QDictIterator<InitCanvas>(dInit);
     for (; it.current(); ++it)
     {
	  if ( it.current()->isPostInit() )
	       ms->addPostConnection( *(it.current()->getMetaInit()) );
	  else
	       ms->addPreConnection( *(it.current()->getMetaInit()) );
     } 
}

void ObjectCanvas::setWire(MetaSheet *ms)
{
     /*QDictIterator<WireCanvas> it1 = QDictIterator<WireCanvas>(dWireSlot);
       for (; it1.current(); ++it1)
       {
       ms->addConnection(*(it1.current()->getMetaWire()));
       } 
     */

     QDictIterator<WireCanvas> it2 = QDictIterator<WireCanvas>(dWireSignal);
     for (; it2.current(); ++it2)
     {
	  ms->addConnection(*(it2.current()->getMetaWire()));
     } 
}

void ObjectCanvas::setObjectPersistence(bool sw)
{
     bool per;

     if (sw)
	  per = getMetaObject()->switchPersistence();
     else
	  per = getMetaObject()->isPersistent();


     QBrush br = brush();

     if (per)
	  br.setStyle(SolidPattern);
     else
	  br.setStyle(Dense5Pattern);

     setBrush(br);
     
     update();
}
