/*
  name: orderdialog.h

  This file is part of ARCS - Augmented Reality Component System,
  written by Jean-Yves Didier, Vincent Le Ligeour and Yoann Petit
  for IBISC Laboratory (http://www.ibisc.univ-evry.fr)

  Copyright (C) 2004 Universit d'Evry-Val d'Essonne

  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.


  Please send bugreports  with examples or suggestions to
  didier__at__iup.univ-evry.fr
*/


#ifndef ORDERDIALOG_H
#define ORDERDIALOG_H

/*! \file transitioncanvas.h
 * \author Yoann Petit
 * \date 5 Juillet 2005
 * 
 * File describes the dialog for the order of elements
 */

#include <qdialog.h>
#include <qpushbutton.h>
#include <qlistview.h>
#include <qlabel.h>
#include <vector>
#include "initcanvas.h"

#include "sheetview.h"
//#include <qcanvas.h>
 
/*! \brief description
 */
class orderDialog : public QDialog 
{
Q_OBJECT
public:

     /*! \brief orderDialog constructor.
      *  \param *parent Parent of the orderDialog.
      *  \param *name Name of the orderDialog.
      *  \param init Sets if is a initialisation(true) or a connection(false).
      *  \param post Sets if is a post-connection(true) or a pre-connection(false).
      */
     orderDialog( QWidget *parent, const char *name, SheetView* sw, bool init, bool post = true);

     /*! \brief Returns a vector of WireCanvas.
      */
     WireVector getWireVector() { return vWC; }
     
     /*! \brief Returns a vector of InitCanvas.
      */
     InitVector getInitVector() { return vIC; }

public slots:

     /*! \brief Valid the dialog.
      */
     void acceptObject();

     /*! \brief Calls when the user click in the list.
      */
     void Click();

     /*! \brief Calls when a element of the list have to go up.
      */
     void moveUp();

     /*! \brief Calls when a element of the list have to go down.
      */
     void moveDown();

private:
     /*! \brief Init the order dialog.
      */
     void init();

     QPushButton *ok, *cancel, *up, *down;
     QListView *liste;
     SheetView* sheet;
     std::vector<InitCanvas*> vIC;
     std::vector<WireCanvas*> vWC;
     bool typeOfItem;
     bool typeOfInit;

};

#endif  // ORDERDIALOG_H
