/*
  name: projectwriter.h

  This file is part of ARCS - Augmented Reality Component System,
  written by Jean-Yves Didier, Vincent Le Ligeour and Yoann Petit
  for IBISC Laboratory (http://www.ibisc.univ-evry.fr)

  Copyright (C) 2004 Universit d'Evry-Val d'Essonne

  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.


  Please send bugreports  with examples or suggestions to
  didier__at__iup.univ-evry.fr
*/


#ifndef __PROJECTWRITER_H__
#define __PROJECTWRITER_H__

/*! \file projectwriter.h
 * \author Yoann Petit
 * \date 4 Juillet 2005
 * 
 * File describes the class of project writer
 */

#include <qdom.h>
#include <qstringlist.h>

#include <metalibrary/metabase.h>
#include <metalibrary/metalibrary.h>
#include "statemachineview.h"

/*! \brief Class used to write down the content of the xml formats designed for this editor.
 */
class ProjectWriter 
{
public:

     /*! \brief ProjectWriter constructor.
      * \param b tells wether the object written is a block or not.
      */
     ProjectWriter(bool b=false);
     ~ProjectWriter();

     /*! \brief Open a file for Save the graphical part.
      *  \param filename FileName for the save.
      */
     bool writeFile(QString filename);

     /*! \brief Define the filename of the application's file.
      *  \param filename FileName for the save of the application's file.
      */
     void addApplication(QString filename);

     /*! \brief Open a file for Save the graphical part.
      *  \param itsc Iterator on the StateCanvas dictionnary.
      *  \param itsv Iterator on the SheetView dictionnary.
      */
     void addSheets(QDictIterator<StateCanvas> itsc, QDict<SheetView> svs );
     
     void addSheet(SheetView* sv, StateCanvas* sc=NULL);

     QString strippedName(QString s) { return ((block)?s.section("::",1):s); }


private:
     QDomDocument graphique;
     QDomElement eApplication;
     QDomElement eSheets;
     bool block;
};


#endif //__PROJECTWRITER_H__
