/*
  name: selectmemberdialog.cpp

  This file is part of ARCS - Augmented Reality Component System,
  written by Jean-Yves Didier, Vincent Le Ligeour and Yoann Petit
  for IBISC Laboratory (http://www.ibisc.univ-evry.fr)

  Copyright (C) 2004 Universit d'Evry-Val d'Essonne

  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.


  Please send bugreports  with examples or suggestions to
  didier__at__iup.univ-evry.fr
*/


#include <metalibrary/metabase.h>
#include "selectmemberdialog.h"

#include <iostream>

#include <qlabel.h>
#include <qvbox.h>
#include <qstringlist.h>
#include <qstrlist.h>
#include <qmessagebox.h>

using namespace std;


/********************************************************************
 * Dfinition de la classe SelectMemberDialog
 *******************************************************************/

SelectMemberDialog::SelectMemberDialog(QWidget* parent, const char* name, SheetView* sw, MetaLibrary metalib)
     : QDialog( parent, name, TRUE, 0)
{
     sheet = sw;

     // Mise en place des elements
     QVBox *vb1 = new QVBox( this );
     vb1->resize( 350, 300 );

     
     QHBox *hb0 = new QHBox( vb1 );
     hb0->setMargin( 8 );
     hb0->setSpacing( 5 );
     new QLabel( "<font color=red><u><b>Available objects</b></u></font>", hb0 );
     label1= new QLabel( "<font color=blue><u><b>Available "+ columnLabel + "</b></u></font>", hb0 );     
  
     QHBox *hb1 = new QHBox( vb1 );
     hb1->setMargin( 8 );
     hb1->setSpacing( 5 );
     QVBox *vb11 = new QVBox( hb1 );
     QVBox *vb12 = new QVBox( hb1 ); 
    
     listObject = new QListView( vb11 );
     listObject->addColumn( "Objects" );
     listObject->setResizeMode ( QListView::AllColumns );
     listObject->setAllColumnsShowFocus( TRUE );
     listObject->setShowSortIndicator( TRUE );
     listObject->clearFocus(); 
     connect( listObject, SIGNAL(clicked(QListViewItem*)), this, SLOT(objectClick()));

     listSgnSlt = new QListView( vb12 );
     listSgnSlt->addColumn(columnLabel);
     listSgnSlt->setResizeMode ( QListView::AllColumns );
     listSgnSlt->setAllColumnsShowFocus( TRUE );
     listSgnSlt->setShowSortIndicator( TRUE );
     connect( listSgnSlt, SIGNAL(clicked(QListViewItem*)), this, SLOT(sgnsltClick()));
 
  
     QHBox *hb2 = new QHBox( vb1 );
     QVBox *vb21 = new QVBox( hb2 );
     vb21->setMargin( 10 );
     vb21->setSpacing( 0 );
     vb21->setMinimumWidth( 230 );
     QVBox *vb23 = new QVBox( hb2 ); 
     QHBox *hb3 = new QHBox( vb23 );
     hb3->setMargin( 5 );
     hb3->setSpacing( 0 );
     ok = new QPushButton( "Ok", hb3 );
     ok->setMaximumWidth( 40 );
          
     connect( ok, SIGNAL(clicked()), SLOT(acceptObject()) );
     cancel = new QPushButton( "Cancel", hb3 );
     cancel->setMaximumWidth(70);
     connect( cancel, SIGNAL(clicked()), SLOT(reject()) );

     mlawd = metalib;

     init();
}

void SelectMemberDialog::init()
{
     QStringList objects = mlawd.getObjects();
     QDictIterator<MetaObject> ite = MetaObject::getIterator();
     if (ite.count() > 0) 
     {	  
	  for (;ite.current(); ++ite)
	  {
	       isInSheet = false ;
	       if (sheet != NULL)
		    if (sheet->hasObject(ite.currentKey()))
		    {
			 if (sheet->isMacroblock())
			 {
			      if (ite.currentKey().startsWith(sheet->name()))
			      {
				   listObject->insertItem(new QListViewItem( listObject, ite.currentKey().section("::",1)));
				   
			      }
			 }
			 else
			 {
			      listObject->insertItem(new QListViewItem( listObject, ite.currentKey()));
			 }
		    }
	  }
	  listObject->setSelected(listObject->firstChild(), TRUE);
     }
}


void SelectMemberDialog::show()
{
     setCaption(captionDialog);     
     label1->setText( "<font color=blue><u><b>Available "+ columnLabel + "</b></u></font>");
     listSgnSlt->setColumnText(0, columnLabel);
     QDialog::show();
     fillDialog();
}

void SelectMemberDialog::objectClick()
{
     fillDialog();
}


QStrList SelectMemberDialog::retrieveSlots()
{
	  QString cn = (MetaObject::getObject(fullName(listObject->currentItem()->text(0))))->getClassName();
	  QStrList SgnSlt;
	  if ( cn != "MetaBlock" ) 
	       SgnSlt = mlawd.getObjectSlots(cn,true);
	  else
	  {
	       MetaObject* mo = MetaObject::getObject(fullName(listObject->currentItem()->text(0)));
	       if (mo->isBlock())
	       {
		    MetaBlock* mb = (MetaBlock*)mo;
		    if (mb->getMetaBlockLink() != NULL)
			 SgnSlt = MetaBlock::getObjectSlots(mb->getMetaBlockLink()->getID());
	       }
	  }
	  return SgnSlt;
}

QStrList SelectMemberDialog::retrieveSignals()
{
	  QString cn = (MetaObject::getObject(fullName(listObject->currentItem()->text(0))))->getClassName();
	  QStrList SgnSlt;
	  if ( cn != "MetaBlock" ) 
	       SgnSlt = mlawd.getObjectSignals(cn,true);
	  else
	  {
	       MetaObject* mo = MetaObject::getObject(fullName(listObject->currentItem()->text(0)));
	       if (mo->isBlock())
	       {
		    MetaBlock* mb = (MetaBlock*)mo;
		    if (mb->getMetaBlockLink() != NULL)
			 SgnSlt = MetaBlock::getObjectSignals(mb->getMetaBlockLink()->getID());
	       }
	  }
	  return SgnSlt;
}


/********************************************************************
 * Dfinition de la classe SelectSignalDialog
 *******************************************************************/

void SelectSignalDialog::fillDialog() 
{
     listSgnSlt->clear();

     if ( listObject->childCount() != 0 ) 
     {
	  QStrList SgnSlt = retrieveSignals();	  
	  for (uint i=0; i < SgnSlt.count(); i++ )
	       listSgnSlt->insertItem(new QListViewItem( listSgnSlt, SgnSlt.at(i) ) );
	  listObject->setSelected(listObject->currentItem(), TRUE);
	  listSgnSlt->setSelected(listSgnSlt->firstChild(), TRUE);
     }
}

/********************************************************************
 * Dfinition de la classe SelectSlotDialog
 *******************************************************************/

void SelectSlotDialog::fillDialog() 
{
     listSgnSlt->clear();

     if ( listObject->childCount() != 0 ) 
     {
	  QStrList SgnSlt = retrieveSlots();	  
	  for (uint i=0; i < SgnSlt.count(); i++ )
	  {
	       if (type.isEmpty())
		    listSgnSlt->insertItem(new QListViewItem( listSgnSlt, SgnSlt.at(i) ) );
	       else
		    if ( QString(SgnSlt.at(i)).section("(",1,1) == type.section("(",1,1)) 
			 listSgnSlt->insertItem(new QListViewItem( listSgnSlt, SgnSlt.at(i) ) );
	  } 
	  listSgnSlt->setSelected(listSgnSlt->firstChild(), TRUE);
     }
}


/********************************************************************
 * Dfinition de la classe SelectSlotDialog
 *******************************************************************/

void SelectInitDialog::fillDialog() 
{
     listSgnSlt->clear();

     if ( listObject->childCount() != 0 ) 
     {
	  QStrList Slt = retrieveSlots();	  
	  for (uint i=0; i < Slt.count(); i++ )
	  {
	       listObject->setSelected(listObject->currentItem(), TRUE);
	       QString type = QString((QString(Slt.at(i))).section("(",1,1));
	       if (  type.contains(',') == 0 )
		    if ( (    type == "bool)"     ) 
			 || ( type == "int)"      )
			 || ( type == "float)"    )
			 || ( type == "double)"   )
			 || ( type == "QString)"  )
			 || ( type == ")"         )
			 || ( type == "QObject*)" ) )
			 listSgnSlt->insertItem(new QListViewItem( listSgnSlt, Slt.at(i) ) );
	  } 
	  listSgnSlt->setSelected(listSgnSlt->firstChild(), TRUE);
     }
}

