/*
  name: statedialog.h

  This file is part of ARCS - Augmented Reality Component System,
  written by Jean-Yves Didier, Vincent Le Ligeour and Yoann Petit
  for IBISC Laboratory (http://www.ibisc.univ-evry.fr)

  Copyright (C) 2004 Universit d'Evry-Val d'Essonne

  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.


  Please send bugreports  with examples or suggestions to
  didier__at__iup.univ-evry.fr
*/


#ifndef __STATEDIALOG_H__
#define __STATEDIALOG_H__

#include <qdialog.h>
//#include <qlineedit.h>
#include <qcombobox.h>
#include <qpushbutton.h>
#include <qdict.h>
#include "sheetview.h"

class StateDialog : public QDialog 
{
Q_OBJECT
public:
      StateDialog( QWidget *parent, const char *name, QStringList ds);

      QString getStateName() { return state; }
    
public slots:
     void acceptObject();

private:
     QPushButton *ok;
     QPushButton *cancel;
     QComboBox *data;
     QString state;
};

#endif  // ADDSTATEDIALOG_H
