/*
  name: transitiondialog.cpp

  This file is part of ARCS - Augmented Reality Component System,
  written by Jean-Yves Didier, Vincent Le Ligeour and Yoann Petit
  for IBISC Laboratory (http://www.ibisc.univ-evry.fr)

  Copyright (C) 2004 Universit d'Evry-Val d'Essonne

  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.


  Please send bugreports  with examples or suggestions to
  didier__at__iup.univ-evry.fr
*/


#include "transitiondialog.h"
#include <iostream>

#include <qvbox.h>
#include <qmessagebox.h>
#include <qlabel.h>

using namespace std;

TransitionDialog::TransitionDialog( QWidget *parent, const char *name, QStringList ds, bool isSource, QString sourceEtat)
     : QDialog( parent, name)
{
     source = isSource;
     setCaption("Renommer la transition");
// Mise en place des elements
     QVBox *vb1 = new QVBox( this );
     vb1->resize( 220, 160 );

     QHBox *hb0 = new QHBox( vb1 );
     hb0->setMargin( 5 );
     hb0->setSpacing( 5 );
     hb0->setMaximumHeight(30);
     if ( isSource )
	  new QLabel( "<font color=darkblue size=3><u><b>""Etat de source :</b></u></font>", hb0 );
     else
	  new QLabel( "<font color=darkblue size=3><u><b>""Etat de destination :</b></u></font>", hb0 );
 
     QHBox *hb1 = new QHBox( vb1 );
     hb1->setMargin( 5 );
     hb1->setSpacing( 5 );
     hb1->setMaximumHeight(30);
     liste = new QComboBox(hb1);
     liste->insertStringList(ds);  
 
     QHBox *hb2 = new QHBox( vb1 );
     hb2->setMargin( 5 );
     hb2->setSpacing( 5 );
     hb2->setMaximumHeight(30);
     new QLabel( "<font color=darkgreen size=3><u><b>""Nom de la transition :</b></u></font>", hb2 );

     QHBox *hb3 = new QHBox( vb1 );
     hb3->setMargin( 5 );
     hb3->setSpacing( 5 );
     hb3->setMaximumHeight(30);
     data = new QLineEdit( hb3 );
     data->setMaximumSize( 210, 25 );
     data->setValidator(0);
     if ( !isSource ) {
	  data->setText(sourceEtat);
	  data->setEnabled(false);
     }      
 
     QHBox *hb4 = new QHBox( vb1 );
     hb4->setMargin( 5 );
     hb4->setSpacing( 5 );
     hb4->setMaximumHeight(40);

     ok = new QPushButton( "Ok", hb4 );
     ok->setMaximumWidth( 60 );    
     connect( ok, SIGNAL(clicked()), SLOT(acceptObject()) );

     cancel = new QPushButton( "Cancel", hb4 );
     cancel->setMaximumWidth(90);
     connect( cancel, SIGNAL(clicked()), SLOT(reject()) );
}

void TransitionDialog::acceptObject()
{
     if ( source ){
	  isInState = false ;
	  emit transitionPossible(liste->currentText(),data->text(),&isInState);
	  if ( (data->text()).isEmpty() ) {
	    QMessageBox::information( this, "Pour ajouter une transition","Il faut nommer cette nouvelle transition !");
	  }
	  else {
	       if (isInState) {
		    QMessageBox::information( this, "Information","Cette transition existe dj!");
	       }
	       else {
		    accept();
	       }
	  }
     }
     else {
	  accept();
     }
}
