/*
  name: angle.h

  This file is part of ARCS - Augmented Reality Component System,
  written by Jean-Yves Didier, Vincent Le Ligeour and Yoann Petit
  for IBISC Laboratory (http://www.ibisc.univ-evry.fr)

  Copyright (C) 2004 Universit d'Evry-Val d'Essonne

  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.


  Please send bugreports  with examples or suggestions to
  didier__at__iup.univ-evry.fr
*/


#ifndef __ANGLE_H__
#define __ANGLE_H__

#include <metalibrary/metaruntime.h>
#include <qthread.h>
#include <qmutex.h>
#include <iostream>
#include "interface.h"

/*! \brief A demonstration class extending a runtime class to integrate it into another application.
 *
 */
class Angle : public MetaRuntime, public QThread, public InterfaceSample
{
     Q_OBJECT
	  public:
     Angle() : MetaRuntime(), QThread() {} //!< ARCS Constructor
     
     /*! \brief returns an angle
      */
     virtual float getAngle() 
     {
	  msleep(20);
	  emit tic();
	  QMutexLocker ml(&mutex);
	  return angle;
     }

     virtual void uturn() 
     {
	  emit invertStep();
     }

     virtual void runSimulation()
     {
	  start();
     }

protected:
     virtual void run() { startRuntime("rotator.xml",false); }

     public slots:

     /*! \brief sets an angle.
      * 
      * This is intended for an internal use.
      */
     void setAngle(float a) 
     {
	  QMutexLocker ml(&mutex); 
	  angle = a; 
     }

signals:
     void invertStep();
     void tic();

private:
     float angle;
     QMutex mutex;
};

#endif //__ANGLE_H__
