/*
  name: boucle.cpp

  This file is part of ARCS - Augmented Reality Component System,
  written by Jean-Yves Didier, Vincent Le Ligeour and Yoann Petit
  for IBISC Laboratory (http://www.ibisc.univ-evry.fr)

  Copyright (C) 2004 Universit d'Evry-Val d'Essonne

  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.


  Please send bugreports  with examples or suggestions to
  didier__at__iup.univ-evry.fr
*/


#include "boucle.h"
#include <iostream>
#include <fstream>


Boucle::Boucle(QObject* obj, const char* name) : QObject(obj, name)
{

}


void Boucle::setIterations(int n)
{
     for (int i = 0; i < n ; i++)
     {
	std::cout << "Emitting iteration " << i << std::endl;
	  emit newIteration(i);
     }
     emit sendToken("end");
}


DisplayInt::DisplayInt(QObject* obj, const char* name) : QObject(obj, name)
{

}


void DisplayInt::display(int i)
{
     std::cout << "Recieved integer " << i << std::endl;
}

ComponentNester::ComponentNester(QObject* obj, const char* name) : 
    QObject(obj, name)
{
    nestedComponent = 0;
}

void ComponentNester::setNestedComponent(QObject* obj)
{
    nestedComponent = obj;
}

void ComponentNester::setIterations(int i)
{       
    Boucle* b = dynamic_cast<Boucle*>(nestedComponent);
    if (b != NULL)
        b->setIterations(i);
}



void IntReader::start()
{
	bool b=true;
	std::ifstream infile(filename.ascii());
	if (!infile.is_open())
	{
		std::cerr << "[IRd] couldn't open file " << filename.ascii() << std::endl;
		return;
	}

	int n;
	while(b)
	{
		b = infile >> n;
		emit newIteration(n); 
	}

	emit sendToken("EOF");
	
}
