/*
  name: execdialog.cpp

  This file is part of ARCS - Augmented Reality Component System,
  written by Jean-Yves Didier, Vincent Le Ligeour and Yoann Petit
  for IBISC Laboratory (http://www.ibisc.univ-evry.fr)

  Copyright (C) 2004 Universit d'Evry-Val d'Essonne

  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.


  Please send bugreports  with examples or suggestions to
  didier__at__iup.univ-evry.fr
*/


#include "execdialog.h"
#include <iostream>
#include <qvbox.h>
#include <qdir.h>
#include <qapplication.h>
#include <qfiledialog.h>
#include <qmessagebox.h>
#include <qsettings.h>
#include <qmenubar.h>
#include <qpopupmenu.h>


ExecDialog::ExecDialog(QWidget* parent, const char* name, QString projectPath) :
     QDialog(parent, name, true)

{
     QVBox* vb1 = new QVBox(this);
     vb1->resize(560,640);
     teOut = new QTextEdit(vb1);     
     //teOut->resize(480,640);
     QHBox* hb1 = new QHBox(vb1);
     //hb1->resize(20,300);
     
     hb1->setMargin( 8 );
     hb1->setSpacing( 5 );
 
     bKill = new QPushButton("Kill", hb1);
     bRestart = new QPushButton("Restart",hb1);
     bClose = new QPushButton("Close", hb1);
     

     /*QString*/ 
     if (! fetchEngine())
	  resetEngine();

     //std::cerr << "Param path : " << paramPath << std::endl;
	 std::cout << "runtime path: " << runtimePath << std::endl;
     process = new QProcess(runtimePath, this);

     connect(bClose,SIGNAL(clicked()), this, SLOT(accept()));
     connect(bKill, SIGNAL(clicked()), this, SLOT(kill()));
     connect(bRestart, SIGNAL(clicked()), this, SLOT(restart()));
     connect(process, SIGNAL(processExited()), this, SLOT(finish()));
     connect(process, SIGNAL(readyReadStdout()), this, SLOT(addSTDOut()));
     connect(process, SIGNAL(readyReadStderr()), this, SLOT(addSTDErr()));


	 if (projectPath.isEmpty())
	 {
	      QMenuBar* menu = new QMenuBar(this);
	      menu->insertItem("Load",this,SLOT(loadFile()));
	      QPopupMenu* engine = new QPopupMenu(this);
	      engine->insertItem("Change engine", this, SLOT(changeEngine()));
	      engine->insertItem("Reset engine", this, SLOT(resetEngine()));
	      menu->insertItem("Engine", engine);
	 }
	 else
	 {
	      /*QString*/ paramPath = projectPath.left(projectPath.length() - 3) + "xml";
	      process->addArgument(paramPath);
	      restart();
	 }
}

ExecDialog::~ExecDialog()
{
     delete process;
}



void ExecDialog::resetEngine()
{
#ifdef WIN32
	 runtimePath = QDir::convertSeparators(qApp->applicationDirPath()) + QDir::separator() + "metaruntime.exe";
#else
	 runtimePath = qApp->applicationDirPath() + QDir::separator() + "metaruntime";
#endif
	 setEngine();
}


void ExecDialog::changeEngine()
{
#ifdef WIN32
     QString ext = "Executables (*.exe)";
#else
     QString ext = "Executables (*)";
#endif

     QString s = QFileDialog::getOpenFileName(
	  runtimePath,
	  ext,
	  this,
	  "open file dialog",
	  "Choose an engine" );
     
     if (s.isEmpty())
	  return;

     runtimePath = s;
     setEngine();

}


void ExecDialog::setEngine()
{
     QSettings settings;
     settings.setPath("IBISC - RATC", "ARCS");
     settings.writeEntry("wrapper/engine", runtimePath);
}


bool ExecDialog::fetchEngine()
{
     QSettings settings;
     settings.setPath("IBISC - RATC", "ARCS");
     QString s = settings.readEntry("wrapper/engine");

     if (s.isEmpty())
	  return false;

     runtimePath = s;
     return true;
}

void ExecDialog::loadFile()
{
     QSettings settings;
     settings.setPath("IBISC - RATC", "ARCS");
     QString wpath = settings.readEntry("wrapper/path");


     QString s = QFileDialog::getOpenFileName(
	  wpath,
	  "Applications (*.xml)",
	  this,
	  "open file dialog",
	  "Choose a file" );
     
     if (s.isEmpty())
	  return;

     settings.writeEntry("wrapper/path", QDir::convertSeparators(QDir(s).absPath()));
     
     
     process->clearArguments();
     process->addArgument(runtimePath);
     paramPath = QDir::convertSeparators(s);
     process->addArgument(paramPath);
     restart();

}

void ExecDialog::restart()
{
     bKill->setEnabled(true);
     bRestart->setEnabled(false);
     bClose->setEnabled(false);

     teOut->clear();

     if (paramPath.isEmpty())
     {
         QSettings settings;
         settings.setPath("IBISC - RATC", "ARCS");
         QString wpath = settings.readEntry("wrapper/path");
         if (wpath.isEmpty())
             return ;
         if (!QFile::exists(wpath))
             return;

         paramPath = wpath;
        process->addArgument(paramPath);
        teOut->append("\nLaunching " + paramPath + "\n");


     }


     if (!process->start())
     {
	  teOut->setColor(QColor(128,0,0));
	  teOut->append("Failed to launch ");
	  teOut->append(runtimePath + " " + paramPath);
	  int i = QMessageBox::warning(this,"Critical error" ,"Failed to launch: " + runtimePath + " " + paramPath, 
		  QMessageBox::Retry, QMessageBox::Abort);
	  if (i == QMessageBox::Abort)
		reject();
     }
}


void ExecDialog::kill()
{
     process->kill();
     teOut->setColor(QColor(128,0,0));
     teOut->append("Killed process\n");
     bKill->setEnabled(false);
     bRestart->setEnabled(true);
     bClose->setEnabled(true);
}

void ExecDialog::finish()
{
     teOut->setColor(QColor(0,0,128));
     teOut->append("Process terminated\n");
     bKill->setEnabled(false);
     bRestart->setEnabled(true);
     bClose->setEnabled(true);
}


void ExecDialog::addSTDOut()
{
     QString stdout0(process->readStdout());
     teOut->setColor(QColor(0,128,0));
     teOut->append(stdout0);
}

void ExecDialog::addSTDErr()
{
     QString stdout0(process->readStderr());
     teOut->setColor(QColor(128,0,0));
     teOut->append(stdout0);
}
