/*
  name: initcanvas.h

  This file is part of ARCS - Augmented Reality Component System,
  written by Jean-Yves Didier, Vincent Le Ligeour and Yoann Petit
  for IBISC Laboratory (http://www.ibisc.univ-evry.fr)

  Copyright (C) 2004 Universit d'Evry-Val d'Essonne

  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.


  Please send bugreports  with examples or suggestions to
  didier__at__iup.univ-evry.fr
*/


#ifndef __INITCANVAS_H__
#define __INITCANVAS_H__

/*! \file transitioncanvas.h
 * \author Yoann Petit
 * \date 6 Juillet 2005
 * 
 * File describes InitCanvas
 */

#include <metalibrary/metabase.h>
#include "wirecanvas.h"

/*! \brief InitCanvas description
 * 
 * This is a class use for conections.
 * This is the graphical counterpart of initialisation for an object.
 */
class InitCanvas : public QCanvasEllipse
{
public:
     /*! \brief InitCanvas constructor.
      *  \param *mi MetaInit of the InitCanvas.
      *  \param *ni NodeItem where is connected the InitCanvas.
      *  \param post Type of initialisation, true for a post-connection, false for a pre-connection.
      */
     InitCanvas( MetaInit* mi, NodeItem* ni, bool post);
     ~InitCanvas();

     /*! \brief Returns the RTTI of the InitCanvas.
      *  \return RTTI of the InitCanvas.
      */
     int rtti() const { return RTTI_INITCANVAS; }

     void moveBy(double dx, double dy);

     /*! \brief Returns the MetaInit of the InitCanvas.
      *  \return MetaInit of the InitCanvas.
      */
     MetaInit* getMetaInit(){return myInit;}

     /*! \brief Returns the connection's type of the InitCanvas.
      *  \return True if the connection is a post-connection and false if this is a pre-connection.
      */
     //--> bool getConnect() { return myConnect;}

     bool isPostInit() { return postInit; }
     void setPostInit(bool b) 
	  {
	       if ( b ) //post connexion
		    setBrush( QColor(215,85,85));
	       else
		    setBrush( QColor(80,200,130));
	       postInit = b ;
	       canvas()->update();
	  }


private:
     MetaInit* myInit; //!< InitCanvas's MetaInit
     NodeItem* myNode; //!< InitCanvas's NodeItem
     //-->bool myConnect;
     bool postInit;
     QCanvasLine* initWire;
};

#endif //__INITCANVAS_H__

