/*
  name: initvaluedialog.cpp

  This file is part of ARCS - Augmented Reality Component System,
  written by Jean-Yves Didier, Vincent Le Ligeour and Yoann Petit
  for IBISC Laboratory (http://www.ibisc.univ-evry.fr)

  Copyright (C) 2004 Universit d'Evry-Val d'Essonne

  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.


  Please send bugreports  with examples or suggestions to
  didier__at__iup.univ-evry.fr
*/


#include "initvaluedialog.h"
#include <metalibrary/metabase.h>

#include <iostream>

#include <qlabel.h>
#include <qstringlist.h>
#include <qstrlist.h>
#include <qmessagebox.h>
#include <qvalidator.h>


using namespace std;


InitValueDialog::InitValueDialog( QWidget *parent, const char *name, QString slot, QString value, bool postInit)
     : QDialog( parent, name, TRUE, 0)
{

     setCaption("Initialisation");
     define = false;
// Mise en place des elements
     QVBox *vb1 = new QVBox( this );
     vb1->resize( 220, 160 );
     QHBox *hb = new QHBox( vb1 );
     hb->setMargin( 5 );
     hb->setSpacing( 5 );
     QVBox *vb2 = new QVBox( hb );
     hb->setMaximumHeight(50);

     pre = new QRadioButton("Pre-connexion",vb2);
     post = new QRadioButton("Post-connexion",vb2);

     pre->setChecked ( !postInit );
     post->setChecked ( postInit );

     // Y aura t'il des soucis ?
     connect( pre, SIGNAL(clicked()), this, SLOT(setPostFalse()) );	  
     connect( post, SIGNAL(clicked()), this, SLOT(setPostTrue()) );	       
	  

     QHBox *hb0 = new QHBox( vb1 );
     hb0->setMargin( 5 );
     hb0->setSpacing( 5 );
     hb0->setMaximumHeight(30);
     type = QString(slot.section("(",1,1));
     if ( type == "bool)" ) {
	  t = new QRadioButton("true",hb0);
	  f = new QRadioButton("false",hb0);
	  bool status = (value == "true");
	  t->setChecked ( status );
	  f->setChecked ( !status );
	  connect( t, SIGNAL(clicked()), this, SLOT(setRadioTrue()) );	  
	  connect( f, SIGNAL(clicked()), this, SLOT(setRadioFalse()) );	       
     }
     else {
	  if ( type == ")" ) {
	  }
	  else {
	       if ( type == "QObject*)" ) {
		    cb = new QComboBox ( false, hb0 );
		    QDictIterator<MetaObject> ite = MetaObject::getIterator();
		    for (;ite.current(); ++ite)
			 cb->insertItem(ite.currentKey());
	       }
	       else {
		    data = new QLineEdit( hb0 );
		    data->setMaximumSize( 210, 25 );
		    if ( type == "int)" )
			 data->setValidator( new QIntValidator(data) );
		    else 
			 if ( ( type == "float)" ) || ( type == "double)" ) )
			      data->setValidator( new QDoubleValidator(data) );
			 else 
			      data->setValidator(0);
		    data->setText(value);
	       }
	  }
     }

     defineCombo = NULL;
     fillDefines(vb1, type.left(type.length()-1));
     

     QHBox *hb1 = new QHBox( vb1 );
     hb1->setMargin( 5 );
     hb1->setSpacing( 5 );
     hb1->setMaximumHeight(40);
     ok = new QPushButton( "Ok", hb1 );
     ok->setMaximumWidth( 60 );    
     connect( ok, SIGNAL(clicked()), SLOT(acceptObject()) );
     cancel = new QPushButton( "Cancel", hb1 );
     cancel->setMaximumWidth(90);
     connect( cancel, SIGNAL(clicked()), SLOT(reject()) );
}


void InitValueDialog::fillDefines(QVBox* box,QString type)
{
     if (type=="QObject*")
	  type="object";
     if (type=="QString")
	  type="string";

     QDictIterator<MetaDefine> ite = MetaDefine::getIterator();

     for( ; ite.current(); ++ite )
     {
	  if (ite.current()->getType() == type)
	  {
	       if (defineCombo == NULL)
	       {
		    new QLabel("You can also choose a variable:",box); 
		    defineCombo = new QComboBox(box);
	       }
	       defineCombo->insertItem(ite.currentKey());
	  }
     }
     
     if (defineCombo != NULL)
     {
	  defineCombo->insertItem("",0);
	  defineCombo->setAutoCompletion(true);
     }
}


void InitValueDialog::acceptObject()
{     
     QString value = QString("");
     if ( type == "bool)" ) {
	  if ( t->isChecked() )
	       value = "true";
	  else
	       value = "false";
     }
     else {
	  if ( type == ")" ) {
	       //value reste ""
	  }
	  else {
	       if ( type == "QObject*)" ) {
		    value = cb->currentText();
	       }
	       else {
		    if ( ( type == "int)" )
			 || ( type == "float)" )
			 || ( type == "double)" ) 
			 || ( type == "QString)") ) {
			 value = data->text();
		    }
	       }
	  }
     }    
 
     this->value = value;



     if (defineCombo != NULL)
	  if (!defineCombo->currentText().isEmpty())
	  {
	       this->value = defineCombo->currentText();
	       define = true;
	  }
     

     accept();
}

void InitValueDialog::setPostTrue()
{
	  post->setChecked ( true );	  
	  pre->setChecked ( false );
}

void InitValueDialog::setPostFalse()
{
	  post->setChecked ( false );	  
	  pre->setChecked ( true );
}

void InitValueDialog::setRadioTrue()
{
	  t->setChecked ( true );	  
	  f->setChecked ( false );
}

void InitValueDialog::setRadioFalse()
{
	  t->setChecked ( false );	  
	  f->setChecked ( true );
}
