/*
  name: iocanvas.cpp

  This file is part of ARCS - Augmented Reality Component System,
  written by Jean-Yves Didier, Vincent Le Ligeour and Yoann Petit
  for IBISC Laboratory (http://www.ibisc.univ-evry.fr)

  Copyright (C) 2004 Universit d'Evry-Val d'Essonne

  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.


  Please send bugreports  with examples or suggestions to
  didier__at__iup.univ-evry.fr
*/


//#include "metabase.h"
#include "iocanvas.h"
#include <qpen.h>


IOCanvas::IOCanvas(MetaIO* mi, NodeItem* ni)
    :  QCanvasPolygon( ni->canvas() )
{
     int height;
     myIO = mi;
     myNode = ni;

     
     text = new QCanvasText( MetaObject::stripNamespace( mi->getPublicName() ), ni->canvas());
     line = new QCanvasLine(ni->canvas());
     line->setBrush( QColor(0,0,0) );

     QFont fnt("Times",10);
     text->setFont(fnt);
     text->setZ(700);
     QFontMetrics fntm(fnt);
     height = fntm.height();
     QPointArray pa(3);

     if ( ! ni->isSlot() ) 
     {
	  text->move(ni->x() + 50, ni->y()+ 5 - height/2);//5 pour la taille du triangle et 5 pour le dcalage
	  text->setTextFlags(Qt::AlignLeft);
	  line->setPoints(int(ni->x()+40),int(ni->y()+5),int(ni->x()),int(ni->y()+5));
	  pa[0] = QPoint(int(ni->x()+40),int(ni->y()-5));
	  pa[1] = QPoint(int(ni->x()+50),int(ni->y()+5));
	  pa[2] = QPoint(int(ni->x()+40),int(ni->y()+15));	  
     }
     else 
     {
	  text->move(ni->x() - 50, ni->y()+ 5 - height/2);
	  text->setTextFlags(Qt::AlignRight); 
	  line->setPoints(int(ni->x()-40),int(ni->y()+5),int(ni->x()),int(ni->y()+5));
	  pa[0] = QPoint(int(ni->x()-50),int(ni->y()-5));
	  pa[1] = QPoint(int(ni->x()-40),int(ni->y()+5));
	  pa[2] = QPoint(int(ni->x()-50),int(ni->y()+15));	  
     }
     text->show();


        
     line->setZ(2);
     line->show();


     setPen(QPen( QColor(0,0,0),1) );

     setPoints(pa);
     setBrush(QBrush( QColor(100,255,100)) );
     //move(x,y);
     setZ(700);
     show();   
}

IOCanvas::~IOCanvas()
{
//     delete initWire;
     delete line;
     delete text;
     delete myIO;
}

void IOCanvas::moveBy(double dx, double dy)
{
     QCanvasPolygon::moveBy( dx, dy);
     if (line != NULL)
	  line->moveBy( dx, dy);
     if (text != NULL)
	  text->moveBy( dx, dy);
}


