/*
  name: orderdialog.cpp

  This file is part of ARCS - Augmented Reality Component System,
  written by Jean-Yves Didier, Vincent Le Ligeour and Yoann Petit
  for IBISC Laboratory (http://www.ibisc.univ-evry.fr)

  Copyright (C) 2004 Universit d'Evry-Val d'Essonne

  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.


  Please send bugreports  with examples or suggestions to
  didier__at__iup.univ-evry.fr
*/


#include "orderdialog.h"
#include "listitem.h"

#include <iostream>

#include <qvbox.h>
#include <qmessagebox.h>

using namespace std;

orderDialog::orderDialog( QWidget *parent, const char *name,SheetView* sv, bool init, bool post)
     : QDialog( parent, name, TRUE, 0)
{
     sheet = sv;

     typeOfItem = init;
     typeOfInit = post;

     QVBox *vb1 = new QVBox( this );
     QHBox *hb0 = new QHBox( vb1 );
     hb0->setMargin( 8 );
     hb0->setSpacing( 5 );
     QHBox *hb1 = new QHBox( vb1 );
     hb1->setMargin( 8 );
     hb1->setSpacing( 5 );
     QHBox *vb11 = new QHBox( hb1 );
     vb11->setMargin( 5 );
     vb11->setSpacing( 5 );
     liste = new QListView( vb11 );

     
     if ( typeOfItem ) {
	   vb1->resize( 400, 400 );
	   liste->addColumn( "Object" );
	   liste->addColumn( "Slot" );
	  if ( typeOfInit ) {
	       setCaption("Classez les post-connexions");
	       new QLabel( "<font color=darkgreen><u><b>""Post-connexion(s) existante(s)</b></u></font>", hb0 );     
	  }
	  else {
	       setCaption("Classez les pre-connexions");
	       new QLabel( "<font color=darkgreen><u><b>""Pre-connexion(s) existante(s)</b></u></font>", hb0 );     
	  }
     }
     else {
	  vb1->resize( 600, 400 );
	  liste->addColumn( "Source" );
	  liste->addColumn( "Signal" );
	  liste->addColumn( "Destination" );
	  liste->addColumn( "Slot" );
	  setCaption("Classez les connexions");
	  new QLabel( "<font color=darkgreen><u><b>""post-connexion(s) existante(s)</b></u></font>", hb0 );     
     }
     
     liste->setResizeMode ( QListView::AllColumns );
     liste->setAllColumnsShowFocus( TRUE );
     liste->setSorting(-1,false);
     connect( liste, SIGNAL(clicked(QListViewItem*)), this, SLOT(Click()));

     QVBox *vb12 = new QVBox( hb1 );
     vb12->setMargin( 5 );
     vb12->setSpacing( 5 );
     vb12->setMinimumWidth( 50 );
     QVBox *vb121 = new QVBox( vb12 );
     vb121->setMinimumHeight( 80 );
     QVBox *vb122 = new QVBox( vb12 );
     vb122->setMinimumHeight( 50 );
     QVBox *vb123 = new QVBox( vb12 );
     vb123->setMinimumHeight( 80 );
     up = new QPushButton( "Up", vb122 );
     up->setMaximumWidth( 40 );
     connect( up, SIGNAL(clicked()), SLOT(moveUp()) );
     down = new QPushButton( "Down", vb122 );
     down->setMaximumWidth(40);
     connect( down, SIGNAL(clicked()), SLOT(moveDown()) );
 
  
     QHBox *hb2 = new QHBox( vb1 );
     QVBox *vb21 = new QVBox( hb2 );
     vb21->setMargin( 10 );
     vb21->setSpacing( 0 );
     vb21->setMinimumWidth( 250 );
     QVBox *vb22 = new QVBox( hb2 ); 
     QHBox *hb3 = new QHBox( vb22 );
     hb3->setMargin( 5 );
     hb3->setSpacing( 0 );
     ok = new QPushButton( "Ok", hb3 );
     ok->setMaximumWidth( 40 );
     connect( ok, SIGNAL(clicked()), SLOT(acceptObject()) );
     cancel = new QPushButton( "Cancel", hb3 );
     cancel->setMaximumWidth(70);
     connect( cancel, SIGNAL(clicked()), SLOT(reject()) );     

     this->init();
}

void orderDialog::init()
{
     if ( typeOfItem ) {
	  vIC=sheet->getInitVector(typeOfInit);
	  for (int i=vIC.size()-1; i > -1; i--)
	       new ListInitItem( liste, (vIC[i]->getMetaInit())->getObject(),(vIC[i]->getMetaInit())->getSlot(), vIC[i] ) ;
     }
     else {
	  vWC=sheet->getWireVector();
	  for (int i=vWC.size()-1; i > -1; i--)
	       new ListWireItem( liste, (vWC[i]->getMetaWire())->getSender(),(vWC[i]->getMetaWire())->getSignal(), (vWC[i]->getMetaWire())->getReciever(),(vWC[i]->getMetaWire())->getSlot(), vWC[i] ) ;
     }
     
     liste->setSelected( liste->firstChild(), true);
}


void orderDialog::acceptObject()
{
     if ( liste->firstChild() ) {
	  if ( typeOfItem ) {
	       InitVector vIC;
	       liste->setCurrentItem(liste->firstChild());
	       InitCanvas *ic = NULL;
	       do {
		    ic = ((ListInitItem*)(liste->currentItem()))->getPointer();
		    vIC.push_back(ic);
		    liste->setCurrentItem( (liste->currentItem())->nextSibling() );
	       } while ( liste->currentItem() != liste->lastItem() );
	       
	       ic = ((ListInitItem*)(liste->currentItem()))->getPointer();
	       vIC.push_back(ic);
	       this->vIC=vIC;
	  }
	  else {
	       WireVector vWC;
	       liste->setCurrentItem(liste->firstChild());
	       WireCanvas *wc = NULL;
	       do {
		    wc = ((ListWireItem*)(liste->currentItem()))->getPointer();
		    vWC.push_back(wc);
		    liste->setCurrentItem( (liste->currentItem())->nextSibling() );
	       } while ( liste->currentItem() != liste->lastItem() );
	       
	       wc = ((ListWireItem*)(liste->currentItem()))->getPointer();
	       vWC.push_back(wc);
	       this->vWC=vWC;
	  }
     }
     accept();
}

void orderDialog::Click()
{
     liste->setSelected(liste->currentItem(), true);
}

void orderDialog::moveUp()
{
     if ( liste->currentItem() != liste->firstChild() ) {
	  QListViewItem *mu = liste->currentItem();
	  QListViewItem *lvi = liste->firstChild();
	  //on parcour la liste pour retrouver l'tat prcdent ...
	  //...a la selection car un moveItem ne marche que dans un sens
	  liste->setCurrentItem(mu);
	  while ( lvi->nextSibling() != mu )
	       lvi = lvi->nextSibling();
	  lvi->moveItem(mu);
	  liste->setSelected(mu,true);
     }
}

void orderDialog::moveDown()
{
     if ( liste->currentItem() != liste->lastItem() )
	  (liste->currentItem())->moveItem((liste->currentItem())->nextSibling());
}
