/*
  name: rtti.h

  This file is part of ARCS - Augmented Reality Component System,
  written by Jean-Yves Didier, Vincent Le Ligeour and Yoann Petit
  for IBISC Laboratory (http://www.ibisc.univ-evry.fr)

  Copyright (C) 2004 Universit d'Evry-Val d'Essonne

  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.


  Please send bugreports  with examples or suggestions to
  didier__at__iup.univ-evry.fr
*/


#ifndef __RTTI_H__
#define __RTTI_H__

/*! \file rtti.h
 * \author Yoann Petit
 * \date 5 Juillet 2005
 * 
 * File defines the differents RTTI used in the editor
 */

#define RTTI_OBJECTCANVAS 1009
#define RTTI_NODEITEM     1010
#define RTTI_WIRECANVAS   1011
#define RTTI_GRIPWIRE     1012
#define RTTI_LINEWIRE     1013
#define RTTI_INITCANVAS   1014
#define RTTI_IOCANVAS     1015

#define RTTI_STATECANVAS      1003
#define RTTI_TRANSITIONCANVAS 1004

#define DEPTH_CANVASTEXT       1000
#define DEPTH_CANVASELLIPSE    950
#define DEPTH_STATECANVAS      900
#define DEPTH_INITCANVAS       850
#define DEPTH_CANVASPOLYGON    800
#define DEPTH_IOCANVAS         750
#define DEPTH_NODEITEM         700
#define DEPTH_CANVASLINE       650
#define DEPTH_LINEWIRE         600
#define DEPTH_TRANSITIONCANVAS 550
#define DEPTH_WIRECANVAS       500
#define DEPTH_GRIPWIRE         450
#define DEPTH_CANVASRECTANGLE  400
#define DEPTH_OBJECTCANVAS     350

#endif
