/*
  name: selectmemberdialog.h

  This file is part of ARCS - Augmented Reality Component System,
  written by Jean-Yves Didier, Vincent Le Ligeour and Yoann Petit
  for IBISC Laboratory (http://www.ibisc.univ-evry.fr)

  Copyright (C) 2004 Universit d'Evry-Val d'Essonne

  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.


  Please send bugreports  with examples or suggestions to
  didier__at__iup.univ-evry.fr
*/


#ifndef __SELECTMEMBERDIALOG_H__
#define __SELECTMEMBERDIALOG_H__

#include <metalibrary/metalibrary.h>

#include <qdialog.h>
#include <qlistview.h>
#include <qpushbutton.h>
#include <qlabel.h> 

#include "sheetview.h"


class SelectMemberDialog : public QDialog
{
     Q_OBJECT
	  public:
     SelectMemberDialog( QWidget *parent, const char *name, SheetView* sw, MetaLibrary metalib);
     QString getObjectName() {return fullName(objectID); }
     QString getMember() {return member;}

     virtual void fillDialog() = 0; 
     void show();

     protected slots:
	  void acceptObject()
	  {
	       objectID = listObject->currentItem()->text(0);
	       member = listSgnSlt->currentItem()->text(0);
	       accept();
	  }
     void sgnsltClick() { listSgnSlt->setSelected(listSgnSlt->currentItem(), TRUE); }

     void objectClick(); 



protected:
     QStrList retrieveSlots();
     QStrList retrieveSignals();
     QString fullName(QString s) { return ((sheet->isMacroblock())?(QString(sheet->name())+"::"+s):s); }


     MetaLibrary mlawd;
     QListView *listSgnSlt;
     QListView *listObject;
     QString captionDialog;
     QString columnLabel;
     
private:
     QPushButton *ok, *cancel;
     QLabel* label1;
     void init();
     bool isTypeSignal;
     bool setSignal;
     bool isInSheet;
     QString objectID;
     QString member;
     SheetView* sheet;
};


class SelectSignalDialog : public SelectMemberDialog
{
public:
     SelectSignalDialog(QWidget *parent, const char *name, SheetView* sw, MetaLibrary metalib)
	  : SelectMemberDialog(parent,name,sw, metalib)
	  { 
	       captionDialog = "Select a signal"; 
	       columnLabel = "Signal"; 
	  }
     void fillDialog();


};

class SelectSlotDialog : public SelectMemberDialog
{
public:
     SelectSlotDialog(QWidget *parent, const char *name, SheetView* sw, MetaLibrary metalib, QString t=QString::null)
	  : SelectMemberDialog(parent,name,sw, metalib)
	   { 
		captionDialog = "Select a slot"; 
		columnLabel= "Slot";
		type=t;
	   }
     void fillDialog();


private:
     QString type;

};



class SelectInitDialog : public SelectMemberDialog
{
public:
     SelectInitDialog(QWidget *parent, const char *name, SheetView* sw, MetaLibrary metalib)
	  : SelectMemberDialog(parent,name,sw, metalib)
	  {
	       captionDialog = "Select a slot"; 
	       columnLabel = "Slot"; 
	  }
     void fillDialog();
};


#endif  // __SELECTMEMBERDIALOG_H__
