/*
  name: sheetview.cpp

  This file is part of ARCS - Augmented Reality Component System,
  written by Jean-Yves Didier, Vincent Le Ligeour and Yoann Petit
  for IBISC Laboratory (http://www.ibisc.univ-evry.fr)

  Copyright (C) 2004 Universit d'Evry-Val d'Essonne

  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.


  Please send bugreports  with examples or suggestions to
  didier__at__iup.univ-evry.fr
*/


#include "rtti.h"

#include <qwidget.h>
#include <qevent.h>
//#include <qtimer.h>
#include <iostream>
//#include "objectcanvas.h"
#include "sheetview.h"
//#include "wirecanvas.h"
#include <qapplication.h>
#include <qstrlist.h>
#include <qptrlist.h>
#include "gripwire.h"
#include <qwmatrix.h>

using namespace std;
/*
 Rtti_ObjectCanvas = 1009;
 Rtti_NodeItem = 1010;
 Rtti_WireCanvas = 1011;
 Rtti_GripWire = 1012;
 Rtti_LineWire = 1013
 Rtti_InitCanvas = 1014;
*/

SheetView::SheetView( QWidget *parent, const char *name , QString ID)
    : QCanvasView( parent, name )
{
     tokenSenderID = ID;
     myCanvas = new QCanvas( this, "Canvas" );
     myCanvas->setBackgroundColor( Qt::white );
     myCanvas->resize( 3000, 3000 );
     setCanvas( myCanvas );
     cornerImage= new QToolButton(this);
     cornerImage->setIconSet(QIconSet(QPixmap((const char**)iconcomp)));
     cornerImage->resize(20,20);


     //depth = 10;
     //MousePosQueue.setAutoDelete( true );  // delete removed items
     Moving = 0;   // on ne selection rien
     Grip = 0;
     Node = 0;
     Wire = 0;
     Object = 0;
     stt= new SheetTooltip(this);
     macroblock = false;

     dObjectCanvas.setAutoDelete(true);
}


SheetView::~SheetView()
{
     resetPointers();
     delete stt;
}

void SheetView::resetPointers()
{
     Moving = NULL;
     Node = NULL;
     Grip = NULL;
     Wire = NULL;
     Object = NULL;
}


void SheetView::setTokenSender(QString ID)
{
     
     if ( tokenSenderID != ID  ) {
	  if ( !tokenSenderID.isEmpty() ) 
	       dObjectCanvas[tokenSenderID]->setBrush( QColor(180,225,240) );
	  tokenSenderID = ID;
	  dObjectCanvas[tokenSenderID]->setBrush( QColor(255,255,200) );
     }
     else {
	  dObjectCanvas[tokenSenderID]->setBrush( QColor(180,225,240) );
	  tokenSenderID = QString();
     }
}

void SheetView::contextMenuEvent(QContextMenuEvent* e)
{
     QApplication::postEvent(parentWidget(), 
			     new QContextMenuEvent(e->reason(),e->pos(), e->globalPos(), e->state()));
}



void SheetView::contentsMousePressEvent( QMouseEvent *e )
{
     // a list of all items underneath the mouse when it was pressed
     QPoint posmap = (this->inverseWorldMatrix()).map(e->pos());


     QCanvasItemList list = canvas()->collisions(posmap);
     if ( list.isEmpty() )
     {
	  //cout<<"Ya rien l !"<<endl;
	  if ( plWire.count() > 0 )
	       for( uint i=0; i < plWire.count(); ++i )
		    plWire.at(i)->setVisibleGrip(false);
	  if ( Wire != NULL ) 
	  {
	       Wire->setVisibleGrip(false);
	       Wire = NULL;
	  }
     }
     else
     {
	  //cout<<list.first()->rtti()<<endl;

	  switch( list.first()->rtti() )
	  {
	  case 3:
	       for( uint i = 0; i < list.count(); i++)
	       {
		    if (list[i]->rtti() == RTTI_OBJECTCANVAS )
		    {
			 selectObjectCanvas( list[i], posmap);
			 break;
		    }
	       }
	       break;
	  case RTTI_OBJECTCANVAS :
	       selectObjectCanvas( list.first(), posmap);
	       break;
	  case RTTI_NODEITEM :
	       //si ce n'est pas le meme node... on desactive les grip de l'ancien node selectionn
	       if ( ((NodeItem*)Node) != ((NodeItem*)list.first()) )	
	       { 
		    if ( plWire.count() > 0 )
			 for( uint i=0; i < plWire.count(); ++i )
			      plWire.at(i)->setVisibleGrip(false);
	       }
	       selectNodeItem( list.first() );
	       break;
	  case RTTI_LINEWIRE :
	       if ( Wire != NULL ) 
	       {
		    Wire->setVisibleGrip(false);
		    Wire = NULL;
	       }
	       selectWireCanvas( list.first() );
	       break;
	  case RTTI_GRIPWIRE :
	       selectWireGrip( list.first(), posmap);
	       break;
	       //case RTTI_INITCANVAS :
	       //selectInitCanvas(list.first(), e->pos()); 
	       //break;
	  }
     }
}


void SheetView::contentsMouseMoveEvent( QMouseEvent *e )
{ 
     QPoint posmap = (this->inverseWorldMatrix()).map(e->pos());

     if ( Moving )    // si on selectionne un objet
     {	   
	  Moving->moveBy( posmap.x() - MovingStart.x(),
			  posmap.y() - MovingStart.y() );
	  MovingStart = posmap;
     }
     if ( Grip )
     {
	  //recuprer le wire canvas correspondant
	  Wire = (WireCanvas*)(Grip->getWireCanvas());
	  Grip->moveGrip( posmap.x() - MovingStart.x(),
			  posmap.y() - MovingStart.y() );
	  MovingStart = posmap;
	 
     }
     canvas()->update();
}

void SheetView::contentsMouseReleaseEvent( QMouseEvent *e )
{
     QPoint posmap = (this->inverseWorldMatrix()).map(e->pos());

     if ( Moving )    // if we are holding the objet
	  QCanvasItemList list = canvas()->collisions(posmap);

     if ( Grip )
	  Grip->setBrush( QColor( 170, 100, 190) );
    
     Moving = NULL;    
     Grip = NULL;    
     //Wire = NULL;
     canvas()-> update();
}


void SheetView::contentsMouseDoubleClickEvent( QMouseEvent* e)
{
     QPoint posmap = (this->inverseWorldMatrix()).map(e->pos());

     QCanvasItemList list = canvas()->collisions(posmap);
     if ( !list.isEmpty() ) {
	  for( uint i = 0; i < list.count(); i++)
	  {
	       if (list[i]->rtti() == RTTI_OBJECTCANVAS)
	       {
		    ObjectCanvas* oc = (ObjectCanvas*)list[i];
		    if (oc->getMetaObject()->isBlock())
		    {
			 MetaBlock* mb = (MetaBlock*)oc->getMetaObject();
			 //((MyWidget*)this->parent())->changeSheet(oc->getMetaObject()->getID());
			 if (mb->getMetaBlockLink() != NULL)
			      emit changeSheet(mb->getMetaBlockLink()->getID());
			 else
			      emit changeSheet(oc->getMetaObject()->getID());
		    }
		    //cout<<"doubleclick"<<endl;
		    //StateCanvas *sc = (StateCanvas*)list[i];
		    //emit changeSheet(sc->getName());
		    break;
	       }
	  }
     }
}






/************************************************************************************/

/**** Si un ObjectCanvas est selectionn ****/
void SheetView::selectObjectCanvas(QCanvasItem *ci, QPoint pe)
{
     Moving = ((ObjectCanvas*)ci);
     MovingStart = pe;
}

/**** Si un NodeItem est selectionn ****/
void SheetView::selectNodeItem(QCanvasItem *ci)
{
     //cout<<"rtti_nodeitem"<<endl;
     Node = ((NodeItem*)ci);

     // on recupere le label du node correspondant a la selection
     QString nodeInfo = Node->getNodeName();
     Object = (ObjectCanvas*)Node->getObjectCanvas();

     //chercher les wire puis les grip associs puis les faire apparaitre
     
     if ( Node->isSlot() )
	  plWire = Object->getWireSlot(nodeInfo);  
     else
	  plWire = Object->getWireSignal(nodeInfo);  

     if ( plWire.count() > 0 )
	  for( uint i=0; i < plWire.count(); ++i )
	       plWire.at(i)->setVisibleGrip(true);
     
}

void SheetView::selectWireCanvas(QCanvasItem *ci)
{
     LineWire* lw = (LineWire*)ci;
     Wire = (WireCanvas*)lw->getOwner();
     Wire->setVisibleGrip( true );
}

void SheetView::selectWireGrip(QCanvasItem *ci, QPoint pe)
{
     MovingStart = pe;
     Grip = ((GripWire*)ci);
     Grip->setBrush( QColor( 240, 240, 0) );
}


void SheetView::addObject(MetaObject* mo)
{
     ObjectCanvas *bloc = new ObjectCanvas(mo, 200+contentsX(),150+contentsY(),40,40,canvas());
//40 dfinit la hauteur minimal de l'objet
     bloc->setBrush( QColor(180,225,240) );
     bloc->setAnimated( false );
     //bloc->setZ(depth);
     bloc->show();
     // on augmente la profondeur pour les prochains objets( 2 car un object canvas = le rectangle et le texte par dessus)
     //depth = depth +2;
     //registre les objets de la feuille
     dObjectCanvas.insert(mo->getID(), bloc);
     canvas()-> update();
}



void SheetView::addWire(MetaWire* mw)
{
     //WireCanvas* wc = new WireCanvas(mw, NULL, NULL, canvas());
     //cout<<"addwire : "<<mw->getSender().ascii()<<endl; 
     ObjectCanvas *ows = dObjectCanvas[mw->getSender()];
     ObjectCanvas *owr = dObjectCanvas[mw->getReciever()];
     if ( ( ows != NULL)&&( owr != NULL ) )
     {
	  ows->addNode(mw->getSignal(),false);
	  owr->addNode(mw->getSlot(),true);
	  NodeItem *from = ows->getNodeSignal(mw->getSignal());
	  NodeItem *to = owr->getNodeSlot(mw->getSlot());
	  
	  WireCanvas* wc = new WireCanvas(mw, from, to, int(ows->y()), int(ows->getHeight()), int(owr->y()), int(owr->getHeight()));
	  wc->show();
	  
	  
	  ( dObjectCanvas[mw->getSender()] )->registerWire(wc);
	  if ( ows != owr )
	       ( dObjectCanvas[mw->getReciever()] )->registerWire(wc);

	  vWire.push_back(wc);	  
     }
     canvas()-> update();
}

void SheetView::addIO(MetaIO* io, bool isSlot)
{
     ObjectCanvas *oc = dObjectCanvas[io->getObjectName()];
     if (oc != NULL)
     {
	  oc->addNode(io->getIOObjectName(),isSlot);
	  NodeItem* ni;
	  if (isSlot)
	       ni = oc->getNodeSlot(io->getIOObjectName());
	  else
	       ni = oc->getNodeSignal(io->getIOObjectName());
	  IOCanvas* ioc = new IOCanvas(io, ni);
	  ((ObjectCanvas*)ni->getObjectCanvas())->registerIO(ioc);
     }
     canvas()->update();
}


void SheetView::addInit(MetaInit* mi, bool p)
{
     ObjectCanvas *oci = dObjectCanvas[mi->getObject()];
    if ( oci == NULL ) {
	  cerr<<"oci NULL"<<endl;
     }
     else {
	  oci->addNode(mi->getSlot(),true);
	  NodeItem *nii = oci->getNodeSlot(mi->getSlot());
	  if (nii == NULL)
	       cerr << "nii NULL" << endl;
	  //delete du initcanvas s'il existe deja
	  oci->delInit(mi->getSlot());   
	      
	  InitCanvas* ic = new InitCanvas( mi, nii, p);
	  //cerr << "success " << endl;
	  ic->show();
	  oci->registerInit(ic);

	  if ( ic->isPostInit() ) //-->
	       vPostInit.push_back(ic);
	  else
	       vPreInit.push_back(ic);
     }
     canvas()-> update();
}


void SheetView::delObjectCanvas(QString ID) // { dObjectCanvas.remove(ID); }
{
     ObjectCanvas* oc = dObjectCanvas[ID];
     if (oc == NULL)
	  return;

     InitCanvas* ic;
     QString key;

     while( ic = oc->getFirstInit(key))
     {
	  delInit(ic);
	  oc->delInit(key);
     }


     dObjectCanvas.remove(ID);
}

void SheetView::delWire(WireCanvas* wc)
{
     vector<WireCanvas*>::iterator iter;

     if (Wire != NULL)
     {
	  Wire->setVisibleGrip(false);
	  Wire = NULL;
     }

     if ( plWire.count() > 0 )
	  for(uint i=0; i < plWire.count(); ++i )
	       if (plWire.at(i) == wc)
		    plWire.remove(i);

     for (iter=vWire.begin(); iter!=vWire.end(); iter++)
	  if (*iter == wc)
	  {
	       vWire.erase(iter);
	       return;
	  }
     
}

void SheetView::delInit(InitCanvas* ic)
{
     // optimisation de la destruction
     vector<InitCanvas*>::iterator iter;

     if (ic->isPostInit())
     {
	  
	  for (iter=vPostInit.begin(); iter!= vPostInit.end(); iter++)
	       if (*iter == ic)
	       {
		    vPostInit.erase(iter);
		    // Might be dangerous
		    //ic = NULL;
		    return;
	       }
     }
     else
     {
	  for (iter=vPreInit.begin(); iter!= vPreInit.end(); iter++)
	       if (*iter == ic)
	       {
		    vPreInit.erase(iter);
		    return;
	       }
     }
}




void SheetView::switchInit(InitCanvas* ic)
{

     vector<InitCanvas*>::iterator iter;

     if (ic->isPostInit())
     {
	  
	  for (iter=vPostInit.begin(); iter!= vPostInit.end(); iter++)
	       if (*iter == ic)
	       {
		    vPostInit.erase(iter);
		    break;
	       }
	  vPreInit.push_back(ic);
     }
     else
     {
	  for (iter=vPreInit.begin(); iter!= vPreInit.end(); iter++)
	       if (*iter == ic)
	       {
		    vPreInit.erase(iter);
		    break;
	       }
	  vPostInit.push_back(ic);
     }

}




void SheetView::hasObjectInSheet(QString ID, bool *b)
{
//     cout<<ID.ascii()<<"+"<<endl;

     //cout << "Testing in sheet " << 

     QDictIterator<ObjectCanvas> it = QDictIterator<ObjectCanvas>(dObjectCanvas);
     for (; it.current(); ++it)
     {
//	  cout<< "Object " <<  it.currentKey().ascii() <<endl;
	  if ( it.currentKey() == ID ) {
	       *b=true; 
	       break; 
	  }
     } 
}

void SheetView::giveNbrObjInSheet( int *nbr )
{
     *nbr = dObjectCanvas.count();
}

void SheetView::setInit(MetaSheet * ms)
{     
     for (unsigned int i=0; i < vPostInit.size(); i++)
	  if (vPostInit[i] != NULL)
	       if ( vPostInit[i]->getMetaInit() != NULL)
		    ms->addPostConnection( *(vPostInit[i]->getMetaInit()) );
     for (unsigned int i=0; i < vPreInit.size(); i++)
	  if (vPreInit[i] != NULL)
	       if ( vPreInit[i]->getMetaInit() !=NULL)
		    ms->addPreConnection( *(vPreInit[i]->getMetaInit()) );
}

void SheetView::setWire(MetaSheet * ms)
{
     
     for (unsigned int i=0; i < vWire.size(); i++)
	  if (vWire[i])
	       ms->addConnection(*(vWire[i]->getMetaWire()));
}

void SheetView::setInitVector( InitVector vIC , bool post)
{
     if ( post ) {
	  vPostInit.clear();
	  for (unsigned int i=0; i < vIC.size(); i++)
	       vPostInit.push_back(vIC[i]);     
     }
     else {
	  vPreInit.clear();
	  for (unsigned int i=0; i < vIC.size(); i++)
	       vPreInit.push_back(vIC[i]);     
     }
}

void SheetView::setWireVector( WireVector vWC)
{
	  vWire.clear();
	  for (unsigned int i=0; i < vWC.size(); i++)
	       vWire.push_back(vWC[i]);     
}

void SheetView::getTip(QPoint p, QRect& r, QString& s)
{
     p.setX(p.x() + contentsX());
     p.setY(p.y() + contentsY());
     p = (this->inverseWorldMatrix()).map(p);

     QCanvasItemList list = canvas()->collisions(p);
     
	if ( list.isEmpty() )
	{
		r = QRect(0,0,-1,-1);
		return;
	}
	
	if (list.first()->rtti() == RTTI_INITCANVAS)
	{
		MetaInit* mi = ((InitCanvas*)list.first())->getMetaInit();
		
		s = mi->getSlot() + "\nValeur : " + mi->getValue();
		if (mi->getType() == MetaInit::Define)
		{
		     MetaDefine* md = MetaDefine::getDefine(mi->getValue());
		     if( md != NULL)
			  s += "(" + md->getType() + ":" + md->getValue() + ")";
		}


		if (((InitCanvas*)list.first())->isPostInit())
		     s += "\nPost-initialization";
		else
		     s += "\nPre-initialization"; 

		r = list.first()->boundingRect();

		// recalculer la zone du rectangle dans l'espace widget.
		QWMatrix mat = this->worldMatrix();
		int x,y;
		double w,h;
		mat.map(r.x(), r.y() , &x , &y);
		w = r.width() * mat.m11();
		h = r.height() * mat.m22();
		
		r.setX(x - contentsX());
		r.setY(y - contentsY());
		r.setWidth( (int)w );
		r.setHeight( (int)h ) ;
		return;
	}

	r = QRect(0,0,-1,-1);
	return;	
}
