/*
  name: statecanvas.cpp

  This file is part of ARCS - Augmented Reality Component System,
  written by Jean-Yves Didier, Vincent Le Ligeour and Yoann Petit
  for IBISC Laboratory (http://www.ibisc.univ-evry.fr)

  Copyright (C) 2004 Universit d'Evry-Val d'Essonne

  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.


  Please send bugreports  with examples or suggestions to
  didier__at__iup.univ-evry.fr
*/


#include "statecanvas.h"

#include <iostream>
#include <vector>

using namespace std;


StateCanvas::StateCanvas( QCanvas* canvas, QString ns) :
     QCanvasEllipse(canvas)
{
     scName = ns;
     //On configure notre ellipse
     setBrush( QColor(190,200,255));
     setSize(150,50);

     //On dfinit et configure un label pour afficher le nom de notre tat
     textState = new QCanvasText( ns , canvas );
     textState->setColor( QColor(130,0,170) );
     textState->setTextFlags(Qt::AlignCenter); 
     textState->setZ(6);
     textState->show();
     dTransitionSender.setAutoDelete(true);

     move(200,200);
     setZ(5);
     show();

}

StateCanvas::~StateCanvas()
{
     delete textState;
}


void StateCanvas::moveBy(double dx, double dy)
{
     QCanvasEllipse::moveBy(dx,dy);
     textState->moveBy(dx,dy);

     //On fait bouger tous les transitions partant de cet tat 
     QDictIterator<TransitionCanvas> iteSource( dTransitionSender );
     for( ; iteSource.current(); ++iteSource ) {
	  //On bouge la transition
	  iteSource.current()->setPoints(iteSource.current()->startPoint().x(),iteSource.current()->startPoint().y(),
					 iteSource.current()->endPoint().x()+int(dx),iteSource.current()->endPoint().y()+int(dy));
	  //On Bouge sa fleche
	  iteSource.current()->setFleche(dx,dy,true);
     }
     
     //On fait bouger tous les transitions arrivant  cet tat 
     QDictIterator<TransitionCanvas> iteDest( dTransitionReceiver );
     for( ; iteDest.current(); ++iteDest ) {
	  iteDest.current()->setPoints(iteDest.current()->startPoint().x()+int(dx),iteDest.current()->startPoint().y()+int(dy),
				       iteDest.current()->endPoint().x(),iteDest.current()->endPoint().y());
	  iteDest.current()->setFleche(dx,dy,false);  
     }
     canvas()->update();
}

void StateCanvas::registerTransition(TransitionCanvas *tc)
{
     //On registre chaque transition comme partant d'un tat dans un dictionnaire et idem pour ceux arrivant
     if ( ((StateCanvas*)(tc->getSender()))->getName() == scName )
	  dTransitionSender.insert( tc->getName(), tc);
     if ( ((StateCanvas*)(tc->getReceiver()))->getName() == scName )
	  dTransitionReceiver.insert( tc->getName(), tc);
}

void StateCanvas::renameStateID(QString newID)
{
     scName = newID;
     textState->setText(newID);
}


void StateCanvas::setTransition(MetaConfigWriter *exp)
{
     QDictIterator<TransitionCanvas> it( dTransitionSender );
     for( ; it.current(); ++it ) {
	  exp->addTransition( scName,((StateCanvas*)(it.current()->getReceiver()))->getName(), it.currentKey());
     }
}

void StateCanvas::delTransitionReceiver(TransitionCanvas *tc)
{
     QDictIterator<TransitionCanvas> it(dTransitionReceiver);
     vector<TransitionCanvas*> vtc;
     
     do
     {
	  if (it.current() == tc)
	  {
	       QString key = it.currentKey();
	       TransitionCanvas* tcc = NULL;
	       do
	       {
		    tcc = dTransitionReceiver.take(key);
		    if ((tcc != tc)&&(tcc != NULL))
			 vtc.push_back(tcc);
	       } while ( tcc != NULL );
	       for (unsigned int i=0; i < vtc.size(); i++) 
		    dTransitionReceiver.insert(key, vtc[i]);
	       break;
	  }
	  ++it; 
     } while ( it.current());
     vtc.clear();
}
