/*
  name: transitioncanvas.cpp

  This file is part of ARCS - Augmented Reality Component System,
  written by Jean-Yves Didier, Vincent Le Ligeour and Yoann Petit
  for IBISC Laboratory (http://www.ibisc.univ-evry.fr)

  Copyright (C) 2004 Universit d'Evry-Val d'Essonne

  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.


  Please send bugreports  with examples or suggestions to
  didier__at__iup.univ-evry.fr
*/


#include "transitioncanvas.h"
#include <math.h>

TransitionCanvas::TransitionCanvas( QCanvasItem *from, QCanvasItem *to, QString nameTransition )
    : QCanvasLine( to->canvas() )
{
     tcName = nameTransition;
     tcFrom = from;
     tcTo = to;
     setBrush( QColor(0,0,0) );
     
     //on cre la fleche
     pa =  QPointArray(3);
     fleche = new QCanvasPolygon( to->canvas());
     fleche->setBrush( QColor(0,0,0) );
     fleche->show();  

     //on cre un labelo pur afficher le nom de la transition
     ct = new QCanvasText(nameTransition, to->canvas());
     ct->setZ(10);
     ct->show();

     setFleche(0,0,0);

     setZ(1);
     show();
     to->canvas()->update();
}

TransitionCanvas::~TransitionCanvas()
{
     delete fleche;
     delete ct;
}


void TransitionCanvas::setFleche( double dx, double dy, bool source )
{ 
     double x1=tcFrom->x();
     double y1=tcFrom->y();
     double x2=tcTo->x();
     double y2=tcTo->y();

     //Permet le mouvement de la fleche quand le statecanvas bouge
     if ( source ) {
	  x1+=dx;
	  y1+=dy;
     }
     else {
	  x2+=dx;
	  y2+=dy;
     }
     setPoints(int(x1),int(y1),int(x2),int(y2)); 
     
     //On cherche le point d'intersection entre la doirte entre les deux pointq et l'ellipse
     double angle = atan2((y1 - y2)/25,(x1 - x2)/75);
     double xt = x2 + 75*cos(angle);
     double yt = y2 + 25*sin(angle);

     //On dfinit les deux autres points de notre fleche
     double angle2 = atan2(y1 - y2, x1 - x2);     
     double xu = xt + 15*cos(angle2+(M_PI/10));
     double yu = yt + 15*sin(angle2+(M_PI/10));
     double xv = xt + 15*cos(angle2-(M_PI/10));
     double yv = yt + 15*sin(angle2-(M_PI/10));
     
     //On dfinit notre fleche
     pa.setPoint(0,int(xt),int(yt));
     pa.setPoint(1,int(xu),int(yu));
     pa.setPoint(2,int(xv),int(yv));
     fleche->setPoints(pa);
  
     // le nom de la transition glisse sur une ellipse plus large que celle d'un statecanvas
     double angle3 = atan2((y1 - y2)/75,(x1 - x2)/150);
     double xw = x2 + 120*cos(angle3);
     double yw = y2 + 60*sin(angle3);
     ct->move( xw - 15, yw - 5);
}

