/*
  name: include/arcs/arcs.h

  This file is part of ARCS - Augmented Reality Component System
  (version 2-current), written by Jean-Yves Didier 
  for IBISC Laboratory (http://www.ibisc.univ-evry.fr)

  Copyright (C) 2013  Universit d'Evry-Val d'Essonne

  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.


  Please send bugreports  with examples or suggestions to
  jean-yves.didier__at__ibisc.univ-evry.fr
*/


#ifndef __ARCS_H__
#define __ARCS_H__


//! This namespace will contain some constant definitions
/*! \author Jean-Yves Didier
  * \date June, the 4th, 2009
  * \ingroup lib
  */
namespace ARCS
{
     //! Flags to specify in which mode applications should start.
     enum ARCSAppFlag
     {
       ARCS_APP_NONE,  //!< None of the application mode has been selected so far
       ARCS_APP_BASE , //!< For basic applications
       ARCS_APP_EVENT, //!< For applications requiring event loops
       ARCS_APP_THREAD, //!< For applications nested in a thread
       ARCS_APP_THREADEVENT, //!< For applications nested in a thread running with an event loop
       ARCS_APP_GUI //!< For applications running with Qt Widgets
     };


};

#endif // __ARCS_H__
