/*
  name: include/arcs/arcsconstantmodifier.h

  This file is part of ARCS - Augmented Reality Component System
  (version 2-current), written by Jean-Yves Didier 
  for IBISC Laboratory (http://www.ibisc.univ-evry.fr)

  Copyright (C) 2013  Universit d'Evry-Val d'Essonne

  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.


  Please send bugreports  with examples or suggestions to
  jean-yves.didier__at__ibisc.univ-evry.fr
*/


#ifndef __ARCSCONSTANTMODIFIER_H__
#define __ARCSCONSTANTMODIFIER_H__

#include <QObject>
#include <QMap>
#include <arcs/arcsqdynamicobject.h>

//! A class to store constants in contexts.
/*! \author Jean-Yves Didier
  * \date October, the 7th, 2009
  * \ingroup lib
  */
 class ARCSConstantModifier : public QObject, public ARCSQDynamicObject
 {
 public:
      ARCSConstantModifier(QObject* parent=0) : QObject(parent) { idx = 0;}

     virtual int qt_metacall(QMetaObject::Call call, int id, void ** arguments);
     virtual QStringList getSignalList() ;
     virtual QStringList getSlotList() ;
     virtual int prepareSlotConnect(QString sigName, QString sltName, QString objectName = QString::null, QString actualSignal = QString::null, bool simulate = false) ;
     virtual int prepareSignalConnect(QString sigName, QString sltName, QString objectName = QString::null, QString actualSlot = QString::null, bool simulate = false);
     virtual int cleanSlotConnect(QString sigName, QString sltName, QString objectName, QString actualSignal);
     virtual int cleanSignalConnect(QString sigName, QString sltName, QString objectName, QString actualSlot);

 private:
     class ConstantAttributes
     {
          public:
          ConstantAttributes(QString sig=QString::null, QString cst= QString::null, int t=0)
          { signature = sig; constantName = cst; type = t; }
          ConstantAttributes(const ConstantAttributes & att )
          {
               signature = att.signature;
               constantName = att.constantName ;
               type = att.type;
          }

          QString getConstantName() { return constantName ; }
          int getType() { return type; }

          private:
          QString signature ;
          QString constantName ;
          int type;
     };

     QMap<QString, int> map; // this should map a signal to a an integer, which is a slot.
     QMap<int, ConstantAttributes> invertMap;
     int idx;

 };

#endif // __ARCSCONSTANTMODIFIER_H__
