/*
  name: include/arcs/arcsdll.h

  This file is part of ARCS - Augmented Reality Component System
  (version 2-current), written by Jean-Yves Didier 
  for IBISC Laboratory (http://www.ibisc.univ-evry.fr)

  Copyright (C) 2013  Universit d'Evry-Val d'Essonne

  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.


  Please send bugreports  with examples or suggestions to
  jean-yves.didier__at__ibisc.univ-evry.fr
*/


/*! \file arcsdll.h
 *
 * This file is defining several macros to maintain code compatibility
 * between Linux and Windows. The first one is for generating and linking dlls,
 * the second one is for solving troubles with inline functions within dlls.
 * \author Jean-Yves Didier
 * \date October, 2007
 * \ingroup lib
 */

#ifndef DLL_POINT
	#ifdef WIN32
		#ifdef BUILD_DLL
			#define DLL_POINT __declspec(dllexport)
		#else
			#define DLL_POINT __declspec(dllimport)
		#endif //BUILD_DLL
	#else 
		#define DLL_POINT
	#endif //WIN32
#endif // DLL_POINT

#ifndef INLINE_MACRO
	#ifdef WIN32
		#define INLINE_MACRO(A,B) inline A; 
	#else
		#define INLINE_MACRO(A,B) A { B } 
	#endif //WIN32
#endif // INLINE_MACRO


