/*
  name: include/arcs/arcsgenerallogger.h

  This file is part of ARCS - Augmented Reality Component System
  (version 2-current), written by Jean-Yves Didier 
  for IBISC Laboratory (http://www.ibisc.univ-evry.fr)

  Copyright (C) 2013  Universit d'Evry-Val d'Essonne

  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.


  Please send bugreports  with examples or suggestions to
  jean-yves.didier__at__ibisc.univ-evry.fr
*/


#ifndef __ARCSGENERALLOGGER_H__
#define __ARCSGENERALLOGGER_H__

#include <arcs/arcsqdynamicobject.h>
#include <QObject>
#include <QMutex>
#include <QMap>
#include <QList>
#include <QMetaType>
#include <iostream>
#include <fstream>


//! Base class for ARCSGeneralLogger
/*! \author Jean-Yves Didier
  * \date September, the 28nd, 2009
  * \ingroup lib
  */
class ARCSGeneralLoggerBase : public QObject
{
     Q_OBJECT

public:
     ARCSGeneralLoggerBase(QObject* parent= 0) : QObject(parent) { separator = " "; }
     ~ARCSGeneralLoggerBase() { if (logFile.is_open() ) logFile.close(); }

public slots:
     void setFilename(QString s);
     void setSeparator(QString sep) { separator = sep; }
     void endLine() { logFile << std::endl; }

protected:
     bool canLog();
     std::ofstream logFile;
     QString separator;
};

//! General purpose logging component.
/*! \author Jean-Yves Didier
  * \date September, the 28th, 2009
  * \ingroup lib
  */
class ARCSGeneralLogger : public ARCSGeneralLoggerBase, public ARCSQDynamicObject
{
public:
     ARCSGeneralLogger(QObject* parent=0) ;
     virtual ~ARCSGeneralLogger()  {}

     virtual int qt_metacall(QMetaObject::Call call, int id, void ** arguments);
     virtual QStringList getSignalList() ;
     virtual QStringList getSlotList() ;
     virtual int prepareSlotConnect(QString sigName, QString sltName, QString objectName = QString::null, QString actualSignal = QString::null, bool simulate = false) ;
     virtual int prepareSignalConnect(QString sigName, QString sltName, QString objectName = QString::null, QString actualSlot = QString::null, bool simulate = false);
     virtual int cleanSlotConnect(QString sigName, QString sltName, QString objectName, QString actualSignal);
     virtual int cleanSignalConnect(QString sigName, QString sltName, QString objectName, QString actualSlot);

private:
     class LogDetails
     {
          public:
          LogDetails(const LogDetails& ld);
          LogDetails(QString sn = QString::null);

          void addType(int id) { typeIds.append(id); }
          int count() { return typeIds.count(); }

          QString getSignature() { return signature; }

          int getArgument(int i)
          {
               int id = QMetaType::Void;
               if (i < count())
               {
                    id = typeIds[i];
               }
               return id;
          }

          private:
          QString signature;
          QList<int> typeIds;
     };


     QMutex mutex;
     int idx;

     QMap<QString, int> map; // this should map a signal to a an integer, which is a slot.
     QMap<int, LogDetails> invertMap;
};




#endif // __ARCSGENERALLOGGER_H__
