/*
  name: include/arcs/arcsinterface.h

  This file is part of ARCS - Augmented Reality Component System
  (version 2-current), written by Jean-Yves Didier 
  for IBISC Laboratory (http://www.ibisc.univ-evry.fr)

  Copyright (C) 2013  Universit d'Evry-Val d'Essonne

  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.


  Please send bugreports  with examples or suggestions to
  jean-yves.didier__at__ibisc.univ-evry.fr
*/


#ifndef __ARCSINTERFACE_H__
#define __ARCSINTERFACE_H__

#include<QStringList>

class ARCSAbstractComponent;


//! A class describing interfaces of components.
/*! \author Jean-Yves Didier
  * \date April, the 11th, 2009
  * \ingroup lib
  */
class ARCSInterface
{
public:
     ARCSInterface() { baseClass = "QObject"; }
     ARCSInterface(ARCSAbstractComponent* cmp) { importFromComponent(cmp); }
     ARCSInterface(const ARCSInterface & inf);

     QStringList getSlots() { return slotList; }
     QStringList getSignals() { return signalList; }
     bool addSlot(QString s) { if (slotList.contains(s)) return false; slotList << s ;  return true; }
     bool addSignal(QString s) { if (signalList.contains(s)) return false; signalList << s ;  return true; }
     bool removeSlot(QString s) { if (!slotList.contains(s))  return false; slotList.removeAll(s); return true; }
     bool removeSignal(QString s) { if (!signalList.contains(s))  return false; signalList.removeAll(s); return true; }

     bool hasSignal(QString s) { return signalList.contains(s); }
     bool hasSlot(QString s) { return slotList.contains(s); }

     void clear() { signalList.clear(); slotList.clear(); }
     void importFromComponent(ARCSAbstractComponent* cmp);
     bool checkComponentInterface(ARCSAbstractComponent* cmp);

     void setClassName(QString s) { className = s ; }
     void setBaseClass(QString s) { baseClass = s ; }

     QString getClassName() { return className ;}
     QString getBaseClass() { return baseClass ;}

     QString getHeaderDeclaration();


private :
     QStringList signalList;
     QStringList slotList;
     QString className;
     QString baseClass;
};

#endif // __ARCSINTERFACE_H__
