/*
  name: include/arcs/arcsinternaltypes.h

  This file is part of ARCS - Augmented Reality Component System
  (version 2-current), written by Jean-Yves Didier 
  for IBISC Laboratory (http://www.ibisc.univ-evry.fr)

  Copyright (C) 2013  Universit d'Evry-Val d'Essonne

  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.


  Please send bugreports  with examples or suggestions to
  jean-yves.didier__at__ibisc.univ-evry.fr
*/


#ifndef __ARCSINTERNALTYPES_H__
#define __ARCSINTERNALTYPES_H__

#include <arcs/arcsarray.h>
#include <QMetaType>
#include <QSize>

/*class ARCSTypeFactory_void : public ARCSTypeFactoryTemplate<void>
{
public:
     virtual QString getTypeName() const { return "void"; }
     virtual bool isInternal() const { return true; }

protected:
     virtual void parse(QString s) { return ; }
     virtual QString serielize(void) { return QString::null; }
     }*/

class ARCSTypeFactory_void : public ARCSTypeFactory
{
public:
     virtual QString getTypeName() const { return "void"; }
     virtual bool isInternal() const { return true; }
     virtual QString toString(QVariant) { return ""; }
     virtual QVariant parseString(QString) { return QVariant(); }
};


class ARCSTypeFactory_bool : public ARCSTypeFactoryTemplate<bool>
{
public :
     virtual QString getTypeName() const { return "bool"; }
     virtual bool isInternal() const { return true; }
protected :
          virtual bool parse(QString s) {
               if (s.toLower() == "true" || s == "1" || s.toLower() =="t" ) return true;
               return false; }

          virtual QString serialize(bool obj) { return (obj)?"true":"false"; }
};


class ARCSTypeFactory_int : public ARCSTypeFactoryTemplate<int>
{
public:
     virtual QString getTypeName() const { return "int"; }
     virtual bool isInternal() const { return true; }

protected:
     virtual int parse(QString s) { return s.toInt(); }
     virtual QString serialize(int obj) { return QString::number(obj);}

};

class ARCSTypeFactory_short : public ARCSTypeFactoryTemplate<short>
{
public:
     virtual QString getTypeName() const { return "short"; }
     virtual bool isInternal() const { return true; }
protected:
     virtual short parse(QString s) { return s.toShort(); }
     virtual QString serialize(short obj) { return QString::number(obj); }
};

class ARCSTypeFactory_long : public ARCSTypeFactoryTemplate<long>
{
public:
     virtual QString getTypeName() const { return "long"; }
     virtual bool isInternal() const { return true; }
protected:
     virtual long parse(QString s) { return s.toLong(); }
     virtual QString serialize(long obj) { return QString::number(obj); }
};

class ARCSTypeFactory_float : public ARCSTypeFactoryTemplate<float>
{
public:
     virtual QString getTypeName() const { return "float"; }
     virtual bool isInternal() const { return true; }
protected:
     virtual float parse(QString s) { return s.toFloat(); }
     virtual QString serialize(float obj) { return QString::number(obj); }
};

class ARCSTypeFactory_double : public ARCSTypeFactoryTemplate<double>
{
public:
     virtual QString getTypeName() const { return "double"; }
     virtual bool isInternal() const { return true; }
protected:
     virtual double parse(QString s) { return s.toDouble(); }
     virtual QString serialize(double obj) { return QString::number(obj); }
};

class ARCSTypeFactory_QString : public ARCSTypeFactoryTemplate<QString>
{
public:
     virtual QString getTypeName()  const { return "string"; }
     virtual bool isInternal() const { return true; }

protected:
     virtual QString parse(QString s) { return s; }
     virtual QString serialize(QString obj) { return obj; }
};

class ARCSConstant : public QString
{
public:
ARCSConstant(QString s) : QString(s) { }
ARCSConstant() : QString() {}
};

Q_DECLARE_METATYPE(ARCSConstant)

class ARCSTypeFactory_ARCSConstant : public ARCSTypeFactoryTemplate<ARCSConstant>
{
public:
     virtual QString getTypeName() const { return "constant"; }
     virtual bool isInternal() const { return true; }

protected:
     virtual ARCSConstant parse(QString s) { return ARCSConstant(s); }
     virtual QString serialize(ARCSConstant obj) { return obj; }
};

class ARCSComponent : public QString
{
public:
ARCSComponent(QString s) : QString(s) { }
ARCSComponent() : QString () {}
};

Q_DECLARE_METATYPE(ARCSComponent)

class ARCSTypeFactory_ARCSComponent : public ARCSTypeFactoryTemplate<ARCSComponent>
{
    public:
    virtual QString getTypeName() const { return "component"; }
    virtual bool isInternal() const { return true; }

    protected:
    virtual ARCSComponent parse(QString s) { return ARCSComponent(s); }
    virtual QString serialize(ARCSComponent obj) { return obj; }
};


class ARCSTypeFactory_QSize : public ARCSTypeFactoryTemplate<QSize>
{
     public:
     virtual QString getTypeName() const { return "size"; }
     virtual bool isInternal() const { return true; }

     protected:
     virtual QSize parse(QString s) ;
     virtual QString serialize(QSize s);
};

/**************************************************************************
  * Arrays
  *************************************************************************/
template class ARCSArrayTemplate<bool>;
typedef ARCSArrayTemplate<bool> boolArray;
Q_DECLARE_METATYPE(boolArray)
class ARCSTypeFactory_boolArray : public ARCSArrayFactoryTemplate<bool>
{
public:
     virtual bool isInternal() const { return true; }
protected:
     QString baseType() const { return "bool"; }
};


template class ARCSArrayTemplate<int>;
typedef ARCSArrayTemplate<int> intArray;
Q_DECLARE_METATYPE(intArray)
class ARCSTypeFactory_intArray : public ARCSArrayFactoryTemplate<int>
{
public:
     virtual bool isInternal() const { return true; }
protected:
     QString baseType() const { return "int"; }
};

template class ARCSArrayTemplate<short>;
typedef ARCSArrayTemplate<short> shortArray;
Q_DECLARE_METATYPE(shortArray)
class ARCSTypeFactory_shortArray : public ARCSArrayFactoryTemplate<short>
{
     public:
     virtual bool isInternal() const { return true; }
     protected:
    QString baseType() const { return "short"; }
};

template class ARCSArrayTemplate<long>;
typedef ARCSArrayTemplate<long> longArray;
Q_DECLARE_METATYPE(longArray)
class ARCSTypeFactory_longArray : public ARCSArrayFactoryTemplate<long>
{
     public:
     virtual bool isInternal() const { return true; }
     protected:
    QString baseType() const { return "long"; }
};

template class ARCSArrayTemplate<double>;
typedef ARCSArrayTemplate<double> doubleArray;
Q_DECLARE_METATYPE(doubleArray)
class ARCSTypeFactory_doubleArray : public ARCSArrayFactoryTemplate<double>
{
     public:
     virtual bool isInternal() const { return true; }
     protected:
    QString baseType() const { return "double"; }
};

template class ARCSArrayTemplate<QString>;
typedef ARCSArrayTemplate<QString> stringArray;
Q_DECLARE_METATYPE(stringArray)
class ARCSTypeFactory_stringArray : public ARCSArrayFactoryTemplate<QString>
{
     public:
     virtual bool isInternal() const { return true; }
     protected:
    QString baseType() const { return "string"; }
};



template class ARCSArrayTemplate<float>;
typedef ARCSArrayTemplate<float> floatArray;
Q_DECLARE_METATYPE(floatArray)
class ARCSTypeFactory_floatArray : public ARCSArrayFactoryTemplate<float>
{
     public:
     virtual bool isInternal() const { return true; }
     protected:
    QString baseType() const { return "float"; }
};



#endif //__ARCSINTERNALTYPES_H__
