/*
  name: include/arcs/arcsmethod.h

  This file is part of ARCS - Augmented Reality Component System
  (version 2-current), written by Jean-Yves Didier 
  for IBISC Laboratory (http://www.ibisc.univ-evry.fr)

  Copyright (C) 2013  Universit d'Evry-Val d'Essonne

  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.


  Please send bugreports  with examples or suggestions to
  jean-yves.didier__at__ibisc.univ-evry.fr
*/


#ifndef __ARCSMETHOD_H__
#define __ARCSMETHOD_H__

#include <arcs/arcsabstractcomponent.h>

//! A class describing a component/method pair
/*! \author Jean-Yves Didier
 * \date December, the 12th, 2008
 * \ingroup lib
 */
class ARCSMethod
{
public:
     ARCSMethod(ARCSAbstractComponent* cmp = 0, QString s = QString::null) { component = cmp; methodName = s; }
     ARCSMethod(const ARCSMethod & method) { component = method.component; methodName = method.methodName; }

     QString getMethodName() { return methodName; }
     ARCSAbstractComponent* getComponent() { return component; }
     
private:
     ARCSAbstractComponent* component;
     QString methodName;
};


#endif //__ARCSMETHOD_H__
