/*
  name: include/arcs/arcsproxycomponent.h

  This file is part of ARCS - Augmented Reality Component System
  (version 2-current), written by Jean-Yves Didier 
  for IBISC Laboratory (http://www.ibisc.univ-evry.fr)

  Copyright (C) 2013  Universit d'Evry-Val d'Essonne

  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.


  Please send bugreports  with examples or suggestions to
  jean-yves.didier__at__ibisc.univ-evry.fr
*/


#ifndef __ARCSPROXYCOMPONENT_H__
#define __ARCSPROXYCOMPONENT_H__

#include <arcs/arcsabstractcomponent.h>
#include <arcs/arcscontext.h>

//! Component linking
/*!  This component acts as a proxy for another component.
 * \author Jean-Yves Didier
 * \date April, the 7th, 2009
 * \ingroup lib
 */

class ARCSProxyComponent : public ARCSAbstractComponent
{
public:
     ARCSProxyComponent() : ARCSAbstractComponent(), realOne(0), context(0), name() {}
     ~ARCSProxyComponent();

     void setContext(ARCSContext* ctx) { context = ctx; }
     ARCSContext* getContext() { return context; }

     virtual QString toString() { return name; }
     virtual bool parseString(QString s)
     {
          if (context)
               realOne = context->getComponent(s);
          if (realOne)
          {
               name = s;
               return true;
          }
          return false;
     }
     virtual QStringList getSignals()
     {
          if (realOne)
               return realOne->getSignals();
          else
               return QStringList();
     }
     virtual QStringList getSlots()
     {
          if (realOne)
               return realOne->getSlots();
          else
               return QStringList();
     }

protected:
     virtual void 	getProxySlot (QString slot, ObjectList &obj, QStringList &proxySlot)
     { if (realOne) realOne->getProxySlot(slot, obj, proxySlot); }
     virtual void 	getProxySignal (QString signal, ObjectList &obj, QStringList &proxySignal)
     { if (realOne) realOne->getProxySignal(signal, obj, proxySignal); }
     virtual bool 	genuineConnect (QString sig, ARCSAbstractComponent *dst, QString slt, bool queued=false)
     {
          if (realOne)
               return realOne->genuineConnect(sig, dst, slt, queued);
          else
               return false;
     }
     virtual bool 	genuineDisconnect (QString sig, ARCSAbstractComponent *dst, QString slt)
     {
          if (realOne)
               return realOne->genuineDisconnect(sig, dst, slt);
          else
               return false;
     }
     virtual bool 	genuineInstanciate ()
     {
          if (realOne)
               realOne->genuineInstanciate();
          else
               return false;
     }
     virtual void 	genuineDestroy ()
     {  if (realOne) realOne->genuineDestroy(); }


private:
     ARCSAbstractComponent* realOne;
     ARCSContext* context;
     QString name;

};

#endif // __ARCSPROXYCOMPONENT_H__
