/*
  name: include/arcs/arcssensorlogger.h

  This file is part of ARCS - Augmented Reality Component System
  (version 2-current), written by Jean-Yves Didier 
  for IBISC Laboratory (http://www.ibisc.univ-evry.fr)

  Copyright (C) 2013  Universit d'Evry-Val d'Essonne

  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.


  Please send bugreports  with examples or suggestions to
  jean-yves.didier__at__ibisc.univ-evry.fr
*/


#ifndef __ARCSSENSORLOGGER_H__
#define __ARCSSENSORLOGGER_H__

#include <arcs/arcsqdynamicobject.h>
#include <QObject>
#include <QMutex>
#include <QMap>
#include <QList>
#include <iostream>
#include <fstream>


//! Base class for ARCSSensorLogger
/*! \author Jean-Yves Didier
  * \date September, the 22nd, 2009
  * \ingroup lib
  */
class ARCSSensorLoggerBase : public QObject
{
     Q_OBJECT

public:
     ARCSSensorLoggerBase(QObject* parent= 0) : QObject(parent) { }
     ~ARCSSensorLoggerBase() { if (logFile.is_open() ) logFile.close(); }

public slots:
     void setFilename(QString s);

protected:
     bool canLog();
     std::ofstream logFile;
};



//! General purpose logging component.
/*! \author Jean-Yves Didier
  * \date September, the 21st, 2009
  * \ingroup lib
  */
class ARCSSensorLogger : public ARCSSensorLoggerBase, public ARCSQDynamicObject
{
public:
     ARCSSensorLogger(QObject* parent=0) ;
     virtual ~ARCSSensorLogger()  {}

     virtual int qt_metacall(QMetaObject::Call call, int id, void ** arguments);
     virtual QStringList getSignalList() ;
     virtual QStringList getSlotList() ;
     virtual int prepareSlotConnect(QString sigName, QString sltName, QString objectName = QString::null, QString actualSignal = QString::null, bool simulate = false) ;
     virtual int prepareSignalConnect(QString sigName, QString sltName, QString objectName = QString::null, QString actualSlot = QString::null, bool simulate = false);
     virtual int cleanSlotConnect(QString sigName, QString sltName, QString objectName, QString actualSignal);
     virtual int cleanSignalConnect(QString sigName, QString sltName, QString objectName, QString actualSlot);

private:
     class LogDetails
     {
          public:
          LogDetails(const LogDetails& ld);
          LogDetails(QString sn = QString::null, QString obj = QString::null, QString s = QString::null);

          void addType(QString name, int id) { typeNames << name ; typeIds.append(id); }
          int count() { return typeNames.count(); }

          QString getSignature() { return signature; }
          QString getObject() { return object; }
          QString getSignal() { return signal; }

          void getArgument(int i,QString& name, int & id)
          {
               if (i < count())
               {
                    name = typeNames[i];
                    id = typeIds[i];
               }
          }

          private:
          QString signature;
          QString object;
          QString signal;
          QStringList typeNames;
          QList<int> typeIds;
     };


     QMutex mutex;
     int idx;

     QMap<QString, int> map; // this should map a signal to a an integer, which is a slot.
     QMap<int, LogDetails> invertMap;
};

#endif // __ARCSSENSORLOGGER_H__
