/*
  name: include/arcs/arcsstatemachine.h

  This file is part of ARCS - Augmented Reality Component System
  (version 2-current), written by Jean-Yves Didier 
  for IBISC Laboratory (http://www.ibisc.univ-evry.fr)

  Copyright (C) 2013  Universit d'Evry-Val d'Essonne

  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.


  Please send bugreports  with examples or suggestions to
  jean-yves.didier__at__ibisc.univ-evry.fr
*/


#ifndef __ARCSSTATEMACHINE_H__
#define __ARCSSTATEMACHINE_H__

#include <QObject>
#include <QHash>
#include <QStringList>
#include <arcs/arcsdll.h>


//! Class describing a state machine in order to control an application
/*! \author Jean-Yves Didier
 * \date January, the 16th, 2009
 * \ingroup lib
 */
class DLL_POINT ARCSStateMachine : public QObject
{
Q_OBJECT

public:
     ARCSStateMachine();

     
     //! Sets the name of the first sheet i.e. the starting node of the statemachine.
     void setFirstSheetName(QString s) { firstSheetName = s; }
     //! Sets the name of the last sheet i.e. the node ending the statemachine.
     void setLastSheetName(QString s) { lastSheetName = s; }

     //! Returns the name of the first state activated in the statemachine.
     QString getFirstSheetName() { return firstSheetName; }
     //! Returns the name of the last state activated in the statemachine.
     QString getLastSheetName() { return lastSheetName; }
     //! Returns the name of the current activated sheet in the statemachine.
     QString getCurrentSheetName() { return currentSheetName; }
     //! Renames a sheet in the set of transitions.
     void renameSheet(QString oldName,QString newName );

     
     void clear();
     void start();
     bool hasError() { return error; }
     void addTransition(QString bState, QString token, QString eState);
     void getTransitions(QStringList & bState, QStringList & token, QStringList & eState); 

     bool hasFinished() { return (currentSheetName == lastSheetName); }

public slots:
     /*! slot receiving a token. The token should activate a transition in the statemachine.
      * Triggers the signal sendSheet() if a transition has been triggered.
      */
     void setToken(QString s);

signals:
     //! signal emitted when a transition has been triggered.
     void sendSheet(QString s);
     //! signal emitted when a state labelled as last state of the statemachine is reached.
     void finished();


private:
     QHash<QString,QHash<QString,QString> > transitions;
     QString firstSheetName;
     QString lastSheetName;
     QString currentSheetName;
     bool error;


};


#endif //__ARCSSTATEMACHINE_H__
