/*
  name: lib/arcsapplicationcomponent.cpp

  This file is part of ARCS - Augmented Reality Component System
  (version 2-current), written by Jean-Yves Didier 
  for IBISC Laboratory (http://www.ibisc.univ-evry.fr)

  Copyright (C) 2013  Universit d'Evry-Val d'Essonne

  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.


  Please send bugreports  with examples or suggestions to
  jean-yves.didier__at__ibisc.univ-evry.fr
*/


#include <arcs/arcsapplicationcomponent.h>
#include <arcs/arcsxmlhandler.h>
#include <arcs/arcsappmode.h>
#include <iostream>
#include <QThread>
#include <QEvent>
#include <arcs/arcslog.h>

ARCSApplicationObject* ARCSApplicationComponent::defaultCore = 0;
void* ARCSApplicationComponent::_interface = 0;

ARCSApplicationComponent* ARCSApplicationComponent::runningInstance = 0;

ARCSApplicationComponent::ARCSApplicationComponent(ARCS::ARCSAppFlag /*flag*/) : QObject()
{
     if (defaultCore == 0)
          defaultCore = new ARCSApplicationObject();

     //! \todo check if there is no regretion after this. Potential instructions to compensate this may appear somewhere.
     /* further check in arcsxmlhandler indicates that this flag should be set to ARCS::ARCS_APP_NONE in order to
       establish that the application is an empty one.
       practically flags are never used for this constructor which is a shame.
    */
     currentMode = ARCS::ARCS_APP_NONE; //flag ; //ARCS::ARCS_APP_NONE;
     setType("Application");
     applicationFinished = true;
     _interface = 0;
}


QVariant ARCSApplicationComponent::getGenuineComponentInstance()
{
     if (!context.getComponent("this"))
     {
         ARCSLog::logInformation(ARCS_SOURCE, "needed to make \"this\"");
          context.addComponent("this", ARCSApplicationComponent::getType());
     }

     QVariant var;
     var.setValue((QObject*)defaultCore);
     return var;
}



/*void* ARCSApplicationComponent::getInterface()
{
     ARCSAbstractComponent* cmp = context.getComponent("this");
     if (cmp)
          cmp->instanciate();
     else
     {
          std::cout << "[App] Needed to add this." << std::endl;
          context.addComponent("this", ARCSApplicationComponent::getType());
          cmp = this;
     }

     std::cout << "cmp : "<< qPrintable(cmp->getType()) << ":"
               << cmp->getGenuineComponentInstance().value<QObject*>() <<std::endl;

     return cmp->getGenuineComponentInstance().value<QObject*>();
}*/


bool ARCSApplicationComponent::startApplication()
{
     int i;
     ARCSLog::logInformation(ARCS_SOURCE,"$ Rev: 207 $");
     applicationFinished = false;

     runningInstance = this;

     getGenuineComponentInstance() ;

     if ( ! context.instanciatePool())
       return false;


     // First loop : starts the processes
     for ( i = 1; i < processes.count() ; i++)
     {
          processes.at(i)->setReferenceApplicationMode(currentMode);
          processes.at(i)->startProcess();
     }

     // Second loop : wait for the processes to enable their first sheet
     for ( i = 1; i < processes.count() ; i++)
          processes.at(i)->waitForFirstSheet();

     processes.at(0)->startProcess();
     
     if (processes.at(0)->hasFinished())
         ARCSLog::logInformation(ARCS_SOURCE,"main process has finished.");
     //applicationFinished = true;
     //runningInstance = 0;
     return true;
}


void ARCSApplicationComponent::finish()
{
     applicationFinished = true;
//     emit finished();
}

bool ARCSApplicationComponent::stopApplication()
{
     runningInstance = 0;
     return false;
}

void ARCSApplicationComponent::removeComponent(QString name)
{
    if ( ! context.getComponentList().contains(name))
        return ;

    // first we have to scan all process and all sheets in order to remove the component from all of this !
    for (int i=0; i < processes.count(); i++)
    {
        int j;
        if (processes[i]->getControllerId() == name)
            processes[i]->setController();
        QStringList sheetNames = processes[i]->getSheetNames();

        for (j=0; j < sheetNames.count(); j++ )
           processes[i]->getSheet(sheetNames[j]).removeComponent(name);
    }

    context.removeComponent(name);
}

bool ARCSApplicationComponent::loadFile(QString s)
{
     ARCSXMLHandler xmlHandler;
     if (! xmlHandler.openFile(s))
          return false;
     return xmlHandler.parseApplication(this);
}

bool ARCSApplicationComponent::parseString(QString s)
{
     if (s.isEmpty())
          return true;

     ARCSXMLHandler xmlHandler;
     xmlHandler.setContents(s);
     return xmlHandler.parseApplication(this);
}


void ARCSApplicationComponent::wait()
{
     //!< \todo reimplement wait.

     for (int i = processes.count()-1 ; i >= 0;i--)
     {
          processes.at(i)->wait();
     }


}

