/*
  name: lib/arcsappmode.cpp

  This file is part of ARCS - Augmented Reality Component System
  (version 2-current), written by Jean-Yves Didier 
  for IBISC Laboratory (http://www.ibisc.univ-evry.fr)

  Copyright (C) 2013  Universit d'Evry-Val d'Essonne

  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.


  Please send bugreports  with examples or suggestions to
  jean-yves.didier__at__ibisc.univ-evry.fr
*/


#include <arcs/arcsappmode.h>
#include <arcs/arcsprocess.h>
#include <arcs/arcscontrollercomponent.h>
#include <arcs/arcslog.h>

#include <QCoreApplication>
#include <QObject>
#include <QLibrary>
#include <QEvent>
//#include <iostream>

ARCSAppMode::ARCSAppMode(ARCSProcess* parent) //: QObject(parent)
{
     parentProcess = parent ;
}

/**********************************************************
 * Classe AppBase
 **********************************************************/
ARCSAppBase::ARCSAppBase(ARCSProcess* parent) : ARCSAppMode(parent)
{

}

void ARCSAppBase::startHook()
{
    ARCSLog::logInformation("Application mode","base");
     parent()->getController()->getStateMachine()->start();
     while(!parent()->hasFinished())
          parent()->setupNextSheet();
}

void ARCSAppBase::tokenHook()
{

}

void ARCSAppBase::stopHook()
{

}

/**********************************************************
 * Classe AppEvent
 **********************************************************/

int ARCSAppEvent::eventType = QEvent::registerEventType();

ARCSAppEvent::ARCSAppEvent(ARCSProcess* parent) : ARCSAppMode(parent)
{
     initHook();
}

void ARCSAppEvent::initHook()
{
     int dargc = 1 ;
     const char* dargv[] = {"ARCS"};

     if (QCoreApplication::instance() == NULL)
          /*QCoreApplication* coreApp =*/ new QCoreApplication(dargc, const_cast<char**>(dargv));
}

void ARCSAppEvent::startHook()
{
    ARCSLog::logInformation("Application mode","event");
     QCoreApplication* app = QCoreApplication::instance();

     if (app == NULL)
          return ;

     QObject::connect(parent(), SIGNAL(finished()), app, SLOT(quit()), Qt::QueuedConnection);
     parent()->getController()->getStateMachine()->start();

     //QCoreApplication::postEvent(parent(), new QEvent(QEvent::ApplicationActivate));
     app->exec();
}

void ARCSAppEvent::tokenHook()
{
     QCoreApplication::postEvent(parent(), new QEvent((QEvent::Type)eventType));
}

void ARCSAppEvent::stopHook()
{


}


/**********************************************************
 * Classe AppThread
 **********************************************************/
ARCSAppThread::ARCSAppThread(ARCSProcess* parent) : QThread(parent), ARCSAppBase(parent)
{

}

void ARCSAppThread::startHook()
{
    ARCSLog::logInformation("Application mode","thread");
     start();
}


void ARCSAppThread::run()
{
    ARCSAppBase::parent()->getController()->getStateMachine()->start();
    ARCSAppBase::parent()->getController()->getStateMachine()->moveToThread(this);

    while(!ARCSAppMode::parent()->hasFinished())
          ARCSAppMode::parent()->setupNextSheet();
}

void ARCSAppThread::stopHook()
{

}

/**********************************************************
 * Classe AppThreadEvent
 **********************************************************/
ARCSAppThreadEvent::ARCSAppThreadEvent(ARCSProcess* parent): QThread(parent), ARCSAppEvent(parent)
{


}

void ARCSAppThreadEvent::startHook()
{
    ARCSLog::logInformation("Application mode","thread event");

     QThread::parent()->moveToThread(this);
     ARCSAppEvent::parent()->getController()->getStateMachine()->moveToThread(this);
     ARCSAppEvent::parent()->getController()->getStateMachine()->start();

     QObject::connect(QThread::parent(), SIGNAL(finished()), this, SLOT(quit()), Qt::QueuedConnection);
     start();
}

void ARCSAppThreadEvent::tokenHook()
{
     QCoreApplication::postEvent(QThread::parent(), 
                                 new QEvent((QEvent::Type)ARCSAppEvent::eventType));
}

void ARCSAppThreadEvent::stopHook()
{

}


void ARCSAppThreadEvent::run()
{
     QCoreApplication::postEvent(QThread::parent(), new QEvent(QEvent::ApplicationActivate));
     exec();
}




/**********************************************************
 * Classe AppGui
 **********************************************************/
ARCSAppGUI::ARCSAppGUI(ARCSProcess* parent) : ARCSAppBase(parent)
{
     initHook();
}

void ARCSAppGUI::initHook()
{
     ARCSLog::logInformation("Application mode","GUI");

     lib.setLoadHints(QLibrary::ResolveAllSymbolsHint|QLibrary::ExportExternalSymbolsHint);
     lib.setFileName("arcsguiw");     
     lib.load();

     if (lib.isLoaded())
     {
          start = (VoidProto)lib.resolve("start_gui_loop");
          init = (VoidProto)lib.resolve("create_gui_application");
          if (init)
               init();
          else
          {
               ARCSLog::logCritical("Application mode","cannot start GUI application.");
               ARCSLog::logCritical("Application mode",lib.errorString());
          }
     }
     else
     {
          ARCSLog::logCritical("Application mode","cannot load GUI library.");
          ARCSLog::logCritical("Application mode",lib.errorString());
     }

     // debugging purpose
     //QCoreApplication* app = QCoreApplication::instance();
}

void ARCSAppGUI::startHook()
{
     QCoreApplication* app = QCoreApplication::instance();

     if (app == NULL)
     {
         ARCSLog::logCritical("Application mode","GUI does not exist.");
          return ;
     }

     if (app->inherits("QApplication"))
          QObject::connect(parent(), SIGNAL(finished()), app, SLOT(closeAllWindows()));
     QObject::connect(parent(), SIGNAL(finished()), app, SLOT(quit()));
     parent()->getController()->getStateMachine()->start();

     QCoreApplication::postEvent(parent(), new QEvent(QEvent::ApplicationActivate));
     if (start)
          start();
}

void ARCSAppGUI::tokenHook()
{
     QCoreApplication::postEvent(parent(), new QEvent((QEvent::Type)ARCSAppEvent::eventType));
}

void ARCSAppGUI::stopHook()
{


}


