/*
  name: lib/arcsinterface.cpp

  This file is part of ARCS - Augmented Reality Component System
  (version 2-current), written by Jean-Yves Didier 
  for IBISC Laboratory (http://www.ibisc.univ-evry.fr)

  Copyright (C) 2013  Universit d'Evry-Val d'Essonne

  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.


  Please send bugreports  with examples or suggestions to
  jean-yves.didier__at__ibisc.univ-evry.fr
*/


#include <arcs/arcsinterface.h>
#include <arcs/arcsabstractcomponent.h>

ARCSInterface::ARCSInterface(const ARCSInterface& inf)
{
     signalList= inf.signalList ;
     slotList  = inf.slotList ;
     baseClass = inf.baseClass ;
     className = inf.className ;
}


void ARCSInterface::importFromComponent(ARCSAbstractComponent* cmp)
{
     clear();
     signalList= cmp->getSignals() ;
     slotList  = cmp->getSlots() ;
     className = cmp->getType() ;
}


bool ARCSInterface::checkComponentInterface(ARCSAbstractComponent* cmp)
{
     int i;

     QStringList cmpSignals = cmp->getSignals();
     QStringList cmpSlots = cmp->getSlots();

     for (i=0; i < signalList.count() ; i++)
          if (!cmpSignals.contains(signalList.at(i)))
               return false;

     for (i=0; i < slotList.count() ; i++)
          if (!cmpSlots.contains(slotList.at(i)))
               return false;

     return true;
}


QString ARCSInterface::getHeaderDeclaration()
{
     QString res;

     res += "#ifndef __" + className.toUpper() + "_H__\n" ;
     res += "#define __" + className.toUpper() + "_H__\n\n" ;
     res += "class " + className + " : public " + baseClass + "\n";
     res += "{\nQ_OBJECT\npublic:\n    " + className + "\n";
     //res +=



     return res;
}
