/*
  name: sample/sample.h

  This file is part of ARCS - Augmented Reality Component System
  (version 2-current), written by Jean-Yves Didier 
  for IBISC Laboratory (http://www.ibisc.univ-evry.fr)

  Copyright (C) 2013  Universit d'Evry-Val d'Essonne

  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.


  Please send bugreports  with examples or suggestions to
  jean-yves.didier__at__ibisc.univ-evry.fr
*/


#ifndef __SAMPLE_H__
#define __SAMPLE_H__

#include <QObject>
#include <arcs/arcsinternaltypes.h>
/*! \defgroup Sample 
 * Small classes used as examples
 */

/*! \brief This class is a loop sending as much iterations as needed.
 *
 * \author Jean-Yves Didier
 * \date March, the 10th, 2009
 * \ingroup Sample
 */
class Loop: public QObject
{
Q_OBJECT
     public:
     //! Default contructor
Loop(QObject* parent = 0) : QObject(parent) {}

public slots:
    //! Gives the number of iterations 
     void setIterations(int n);

signals:
//! Sends an iteration
void newIteration(int i);
//! Sends a token once the number of iterations have been reached.
void sendToken(QString s);
void finished();
};

/*! \brief Displays every integer sent to itself
 * \author Jean-Yves Didier
 * \date March, the 10th, 2009
 * \ingroup Sample
 */
class DisplayInt: public QObject
{
Q_OBJECT
     public:
     //! Default constructor
DisplayInt(QObject* parent = 0) : QObject(parent) {}

public slots:
    //! Displays in the console the number passed as a parameter
     void display(int i);
     void display(intArray ia);
};

/*! \brief Component triggering stack explosions
 *  This component intends to demonstrate how to circumvent stack explosions
 *  using the signal/slot mechanism
 *  \author Jean-Yves Didier
 *  \date April, the 1st, 2009
 *  \ingroup Sample
 */
class StackExploder: public QObject
{
Q_OBJECT
     public:
     StackExploder(QObject* parent = 0) : QObject(parent), calls(0) {}

     public slots:
     void tic();

signals:
     void toc();

private:
     int calls;
};


/*! Proof of concept of component nesting
 * \author Jean-Yves Didier
 * \date April, the 8th, 2009
 * \ingroup Sample
 */
class ComponentNester : public QObject
{
Q_OBJECT
    public :
    ComponentNester(QObject* parent=0);

    public slots:
        void setComponent(QObject* cmp);
    void setIterations(int);

    private:
    Loop* nestedComponent;
};

/*! A simple component, waiting during a certain amount of seconds
 * \author Jean-Yves Didier
 * \date July, the 6th, 2009
 * \ingroup Sample
 */
class Sleeper : public QObject
{
    Q_OBJECT
    public:
        Sleeper(QObject* parent=0) : QObject(parent) {}
    public slots:
        void setSeconds(int);
        void setText(QString s) { text = s; }

    signals:
        void sendToken(QString);

    private:
        QString text;
};


#endif //__SAMPLE_H__
