/*
  name: tools/editor/graphicsportitem.h

  This file is part of ARCS - Augmented Reality Component System
  (version 2-current), written by Jean-Yves Didier 
  for IBISC Laboratory (http://www.ibisc.univ-evry.fr)

  Copyright (C) 2013  Universit d'Evry-Val d'Essonne

  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.


  Please send bugreports  with examples or suggestions to
  jean-yves.didier__at__ibisc.univ-evry.fr
*/


#ifndef __GRAPHICSPORTITEM_H__
#define __GRAPHICSPORTITEM_H__

#include <QGraphicsPathItem>
#include <QGraphicsSimpleTextItem>
#include <QGraphicsRectItem>
#include <QList>
#include <QPen>

class QGraphicsRectItem;
class GraphicsLinkItem;


class GraphicsPortItem : public QGraphicsPathItem {
public:
    GraphicsPortItem(QGraphicsItem* parent);
    ~GraphicsPortItem();

    enum PortType
    {
        Slot,
        Signal
    };

    enum { Type = UserType + 2 };
    int type() const
    {
         return Type;
    }


    void setType(PortType pt) { operationType = pt; updateView(); }
    PortType getType() { return operationType; }
    void setName(QString s); //{ operationName = s ; }
    QString getName() { return operationName; }
    bool isMarkedForDeletion() { return markedForDeletion; }
    void markForDeletion() { markedForDeletion = true; }

    void addLink(GraphicsLinkItem* lnk) { links.append(lnk); }
    void showName() { rectOperation->setVisible(true); }
    void hideName() {  rectOperation->setVisible(false); }

    void removeLinkItem(GraphicsLinkItem* item);

    void fireUpdate();

protected:
    virtual void hoverEnterEvent ( QGraphicsSceneHoverEvent *  );
    virtual void hoverLeaveEvent ( QGraphicsSceneHoverEvent *  );
    virtual void mousePressEvent(QGraphicsSceneMouseEvent *event);
    virtual void mouseMoveEvent(QGraphicsSceneMouseEvent *event);
    virtual void mouseReleaseEvent(QGraphicsSceneMouseEvent* event);
    virtual void contextMenuEvent(QGraphicsSceneContextMenuEvent *event);
    virtual QVariant itemChange(GraphicsItemChange change, const QVariant &value);
    virtual void paint(QPainter *painter, const QStyleOptionGraphicsItem *option, QWidget *widget);


private:
    void updateView();

    QGraphicsSimpleTextItem* textOperation;
    QGraphicsRectItem* rectOperation;
    PortType operationType ;
    QString operationName;
    GraphicsLinkItem* linkInConstruction;

    QList<GraphicsLinkItem*> links;
    QPen defaultPen;
    bool markedForDeletion;

};



#endif // __GRAPHICSPORTITEM_H__
