/*
  name: tools/editor/maineditor.h

  This file is part of ARCS - Augmented Reality Component System
  (version 2-current), written by Jean-Yves Didier 
  for IBISC Laboratory (http://www.ibisc.univ-evry.fr)

  Copyright (C) 2013  Universit d'Evry-Val d'Essonne

  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.


  Please send bugreports  with examples or suggestions to
  jean-yves.didier__at__ibisc.univ-evry.fr
*/


#ifndef __MAINEDITOR_H__
#define __MAINEDITOR_H__

#include <QMainWindow>
#include <QTabWidget>
#include <QStringList>
#include <QVariant>


class QTabWidget;
class QTextEdit;
class LogView;
class ApplicationView;
class QMenu;
class QAction;

class MainEditor : public QMainWindow
{
    Q_OBJECT
public:
    explicit MainEditor(QWidget *parent = 0);
    ~MainEditor();
signals:

public slots:
    void newApplication();
    void saveApplication();
    void saveAsApplication();
    void openApplication(QString s = QString::null);
    void addNewTabWidget(QWidget* wdg);
    void removeTab(int i ) {
        QWidget* widget = tbElements->widget(i);
        tbElements->removeTab(i);
        delete widget;
    }

    void actualizeFromTab(int);

    void handleRecentAction(QAction*);
    void setDefaultApplication(ApplicationView* app);
    void destroyAppId(QVariant appId);
    void destroyWidget(QVariant appId,QString name);

private:
    void buildRecentMenu();

    QTabWidget* tbElements;
    QTextEdit* welcomeWidget;
    LogView* logView;
    QList<ApplicationView*> applications;
    ApplicationView* defaultApplication;
    QStringList recentList ;
    QMenu* recentMenu;

    QAction* saveFileAction;
    QMenu* editMenu;
};

#endif // __MAINEDITOR_H__
