/*
  name: tools/editor/newcomponentdialog.h

  This file is part of ARCS - Augmented Reality Component System
  (version 2-current), written by Jean-Yves Didier 
  for IBISC Laboratory (http://www.ibisc.univ-evry.fr)

  Copyright (C) 2013  Universit d'Evry-Val d'Essonne

  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.


  Please send bugreports  with examples or suggestions to
  jean-yves.didier__at__ibisc.univ-evry.fr
*/


#ifndef __NEWCOMPONENTDIALOG_H__
#define __NEWCOMPONENTDIALOG_H__

#include <QWidget>
#include <QDialog>
#include <arcs/arcscontext.h>

#include <QLineEdit>

//class QLineEdit;
class QPushButton;
class QListWidget;

class NewComponentDialog : public QDialog
{
    Q_OBJECT
public:
    explicit NewComponentDialog(ARCSContext* ctx, QWidget *parent = 0);

    QString getType() { return componentType->text(); }
    QString getName() { return componentName->text(); }


signals:

public slots:
    void verify();
    void setType(QString s);




private:
    ARCSContext* context;

    QLineEdit* componentType;
    QLineEdit* componentName;
    QPushButton* okButton ;
    QPushButton* cancelButton;
    QListWidget* componentTypes;
};

#endif // __NEWCOMPONENTDIALOG_H__
