/*
  name: tools/wizard/arcstablauncher.h

  This file is part of ARCS - Augmented Reality Component System
  (version 2-current), written by Jean-Yves Didier 
  for IBISC Laboratory (http://www.ibisc.univ-evry.fr)

  Copyright (C) 2013  Universit d'Evry-Val d'Essonne

  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.


  Please send bugreports  with examples or suggestions to
  jean-yves.didier__at__ibisc.univ-evry.fr
*/


#ifndef __ARCSTABLAUNCHER_H__
#define __ARCSTABLAUNCHER_H__

#include <QTabWidget>
#include "arcsenginecontext.h"
#include <QProcess>

namespace Ui {
    class ARCSTabLauncher;
}

class QProcess;

class ARCSTabLauncher : public QTabWidget
{
    Q_OBJECT

public:
    explicit ARCSTabLauncher(QWidget *parent = 0);
    ~ARCSTabLauncher();

private:
    void updateTable(ARCSEngineContext aec);
    ARCSEngineContext constantsFromTable();
    Ui::ARCSTabLauncher *ui;
    ARCSEngineContext appContext;
    ARCSEngineContext actualContext;
    int appMode;
    int actualMode;
    QProcess* process;

private slots:
    void on_inputProfileLineEdit_editingFinished();
    void on_applicationLineEdit_editingFinished();
    void on_applicationMode_currentIndexChanged(int index);
    void on_restartButton_clicked();
    void on_killButton_clicked();
    void on_saveProfileButton_clicked();
    void on_restoreValuesButton_clicked();
    void on_launchButton_clicked();
    void on_outputProfileBrowseButton_clicked();
    void on_inputProfileBrowseButton_clicked();
    void on_applicationBrowseButton_clicked();
    void readStdErr();
    void readStdOut();
    void processFinished(int e,QProcess::ExitStatus es);


private:
    void updateApplication(QString s);
     void updateInputProfile(QString s);

};

#endif // __ARCSTABLAUNCHER_H__
