/*
  name: tools/wizard/pathedit.cpp

  This file is part of ARCS - Augmented Reality Component System
  (version 2-current), written by Jean-Yves Didier 
  for IBISC Laboratory (http://www.ibisc.univ-evry.fr)

  Copyright (C) 2013  Universit d'Evry-Val d'Essonne

  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.


  Please send bugreports  with examples or suggestions to
  jean-yves.didier__at__ibisc.univ-evry.fr
*/


#include "pathedit.h"
#include "pathvalidator.h"

#include <QCompleter>
#include <QFileSystemModel>
#include <QPalette>


PathEdit::PathEdit(QWidget *parent) : QLineEdit(parent)
{
     pathCompleter = new QCompleter(this);
     pathModel = new QFileSystemModel(pathCompleter);
     pathModel->setNameFilters(_filter);
     pathModel->setNameFilterDisables(false);
     pathModel->setRootPath(QDir::currentPath());

     pathCompleter->setModel(pathModel);
     pathValidator = new PathValidator(this);

     setCompleter(pathCompleter);
     setValidator(pathValidator);
     setText(QDir::currentPath());

     connect(this,SIGNAL(textChanged(QString)),this,SLOT(validateText(QString)));
}


void PathEdit::validateText(QString)
{
     if (!hasAcceptableInput())
       {
          QPalette palette = this->palette();
          palette.setColor(QPalette::Text,Qt::red);
          setPalette(palette);
     }
     else
     {
          QPalette palette = this->palette();
          palette.setColor(QPalette::Text,parentWidget()->palette().color(QPalette::Text));
          setPalette( palette);
     }

}

void PathEdit::setFilter(QStringList sl)
{
     pathValidator->setFilter(sl);
     pathModel->setNameFilters(sl);

}

bool PathEdit::fileExists() const
{
     return pathValidator->getFileExists();
}

void PathEdit::setFileExists(bool b)
{
     pathValidator->setFileExists(b);
}
