/*
  name: include/arcs/arcsappmode.h

  This file is part of ARCS - Augmented Reality Component System
  (version 2-current), written by Jean-Yves Didier 
  for IBISC Laboratory (http://www.ibisc.univ-evry.fr)

  Copyright (C) 2013  Universit d'Evry-Val d'Essonne

  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.


  Please send bugreports  with examples or suggestions to
  jean-yves.didier__at__ibisc.univ-evry.fr
*/


#ifndef __ARCSAPPMODE_H__
#define __ARCSAPPMODE_H__

//#include <QObject>
#include <QThread>
//#include <QEvent>
#include <QLibrary>

//class ARCSApplicationComponent;
class ARCSProcess;

/*! \brief Base class for launching and handling ARCS applications
 * \author Jean-Yves Didier
 * \date March, the 12th, 2009
 * \ingroup lib
 */
class ARCSAppMode
{
	  public:
     ARCSAppMode(ARCSProcess* parent);//ARCSApplicationComponent* parent);
     virtual ~ARCSAppMode() {}
     /*! \brief Hook for starting applications
      * Subclasses should reimplement this.
      */
     virtual void startHook() = 0;
     /*! \brief Hook for handling tokens
      * Subclasses should reimplement this.
      */
     virtual void tokenHook() = 0;

     /*! \brief Hook for stopping applications
      * Subclasses should reimplement this.
      */
     virtual void stopHook() = 0 ;

protected:
     ARCSProcess*  parent() { return parentProcess; }
     
private: 
     ARCSProcess* parentProcess;

};

/*! \brief Basic application handler
 * \author Jean-Yves Didier
 * \date March, the 12th, 2009
 * \ingroup lib
 */
class ARCSAppBase : public ARCSAppMode
{
public:
     ARCSAppBase(ARCSProcess* parent);
     virtual ~ARCSAppBase() {}
     virtual void startHook();
     virtual void tokenHook();
     virtual void stopHook();
};

/*! \brief Event-loop based application handler 
 * \author Jean-Yves Didier
 * \date March, the 12th, 2009
 * \ingroup lib
 */
class ARCSAppEvent : public ARCSAppMode
{
public:
     ARCSAppEvent(ARCSProcess* parent);
     virtual ~ARCSAppEvent() {}
     virtual void startHook();
     virtual void tokenHook();
     virtual void stopHook();

     static int eventType;

protected:
     virtual void initHook();
     

};


/*! \brief Event-loop based GUI application handler
 * \author Jean-Yves Didier
 * \date April, the 1st, 2009
 * \ingroup lib
 */
class ARCSAppGUI : public ARCSAppBase
{
public:
     ARCSAppGUI(ARCSProcess* parent);
     virtual ~ARCSAppGUI() {}
    virtual void startHook() ;
     virtual void tokenHook();
     virtual void stopHook();

protected:
     typedef void (*VoidProto)();

     virtual void initHook();

private:
     QLibrary lib;
     VoidProto init;
     VoidProto start;
};


/*! \brief Threaded application handler 
 * \author Jean-Yves Didier
 * \date March, the 12th, 2009
 * \ingroup lib
 */
class ARCSAppThread : public QThread, public ARCSAppBase
{
public:
     ARCSAppThread(ARCSProcess* parent);
     virtual ~ARCSAppThread() {}
     virtual void startHook();
     virtual void stopHook();

protected:
     virtual void run();
};

/*! \brief Threaded and event-loop based application handler 
 * \author Jean-Yves Didier
 * \date March, the 12th, 2009
 * \ingroup lib
 */
class ARCSAppThreadEvent : public QThread, public ARCSAppEvent
{

public:
     ARCSAppThreadEvent(ARCSProcess* parent);
     virtual ~ARCSAppThreadEvent() {}
     virtual void startHook();
     virtual void tokenHook();
     virtual void stopHook();
     

protected:
     virtual void run();
};

#endif //__ARCSAPPMODE_H__
