/*
  name: lib/arcscompositecomponent.cpp

  This file is part of ARCS - Augmented Reality Component System
  (version 2-current), written by Jean-Yves Didier 
  for IBISC Laboratory (http://www.ibisc.univ-evry.fr)

  Copyright (C) 2013  Universit d'Evry-Val d'Essonne

  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.


  Please send bugreports  with examples or suggestions to
  jean-yves.didier__at__ibisc.univ-evry.fr
*/


#include <arcs/arcscompositecomponent.h>
#include <arcs/arcsxmlhandler.h>


ARCSCompositeComponent::ARCSCompositeComponent() : ARCSAbstractComponent()
{
     //context = 0;
     //sheet(context);

}


ARCSCompositeComponent::~ARCSCompositeComponent()
{
}



bool ARCSCompositeComponent::genuineInstanciate()
{
     bool b = context.instanciatePool();
     sheet.preconnect();
     sheet.connect();
     sheet.postconnect();
     return b;
}

void ARCSCompositeComponent::genuineDestroy()
{
     sheet.disconnect();
     sheet.cleanup();
}


QStringList ARCSCompositeComponent::getSlots()
{
     return proxySlots.uniqueKeys();
}

QStringList ARCSCompositeComponent::getSignals()
{
     return proxySignals.uniqueKeys();
}




QString ARCSCompositeComponent::toString()
{
    ARCSXMLHandler xmlHandler;
    xmlHandler.storeCompositeComponent(this);
    return xmlHandler.getContents();
}


bool ARCSCompositeComponent::addMethod(QMap<QString, ARCSMethod> &list , QString proxy, QString id, QString method)
{
     ARCSAbstractComponent* cmp = context.getComponent(id);
     if ( cmp == 0)
	  return false;

     list.insertMulti(proxy,ARCSMethod(cmp, method));
     return true;
}


bool ARCSCompositeComponent::parseString(QString s)
{
    ARCSXMLHandler xmlHandler;
     xmlHandler.setContents(s);
     return xmlHandler.parseCompositeComponent(this);
}

bool ARCSCompositeComponent::loadFile(QString fn)
{
    ARCSXMLHandler xmlHandler;
    xmlHandler.openFile(fn);
    return xmlHandler.parseCompositeComponent(this);
}

bool ARCSCompositeComponent::saveFile(QString fn)
{
    ARCSXMLHandler xmlHandler;
    xmlHandler.storeCompositeComponent(this);
    return xmlHandler.saveFile(fn);
}

void ARCSCompositeComponent::getProxySlot(QString slot, ObjectList & obj, QStringList& proxySlot)
{
     QList<ARCSMethod> lst = proxySlots.values(slot);

     // inversion mandatory since calls must be performed in the right order.
     for (int i = lst.count() - 1  ; i >= 0  ; i--)
     {
	  ObjectList objects;
	  QStringList methods;
	  ARCSAbstractComponent::getProxySlot(lst[i].getComponent(),lst[i].getMethodName(), objects, methods);
	  
	  obj << objects;
	  proxySlot << methods;
     }
}


void ARCSCompositeComponent::getProxySignal(QString signal, ObjectList& obj, QStringList& proxySignal)
{
     QList<ARCSMethod> lst = proxySignals.values(signal);

     // inversion mandatory since calls must be performed in the right order.
     for (int i = lst.count()-1 ; i >=0  ; i--)
     {
	  ObjectList objects;
	  QStringList methods;
	  ARCSAbstractComponent::getProxySignal(lst[i].getComponent(),lst[i].getMethodName(), objects, methods);
	  
	  obj << objects;
	  proxySignal << methods;
     }
}


//! \todo remember the intended use of the function below ?!?
void ARCSCompositeComponent::getProxyMethods(QMap<QString,ARCSMethod> & /*list*/,QStringList& /*proxies*/, QStringList& /*objects*/, QStringList& /*methods*/)
{

}



