/*
  name: lib/arcsinit.cpp

  This file is part of ARCS - Augmented Reality Component System
  (version 2-current), written by Jean-Yves Didier 
  for IBISC Laboratory (http://www.ibisc.univ-evry.fr)

  Copyright (C) 2013  Universit d'Evry-Val d'Essonne

  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.


  Please send bugreports  with examples or suggestions to
  jean-yves.didier__at__ibisc.univ-evry.fr
*/


#include <arcs/arcsinit.h>
#include <arcs/arcsfactory.h>

ARCSInit ARCSInit::null = ARCSInit();


ARCSFactory* ARCSInit::factory = 0;


ARCSInit::ARCSInit()
{
     destination = 0;
     slotName = QString::null;
     value = QVariant();
     constant = false;
     component = false;
}


ARCSInit::ARCSInit(const ARCSInit & i)
{
     value = QVariant(i.value);
     destination = i.destination;
     slotName = i.slotName;
     constant = (getValueType() == "constant");
     component = (getValueType() == "component");
}

ARCSInit::ARCSInit(ARCSAbstractComponent* d, QString slt, QVariant v)
{
     value = v;
     destination = d;
     slotName = slt;
     constant = (getValueType() == "constant");
     component = (getValueType() == "component");
}


ARCSInit::~ARCSInit()
{
}


bool ARCSInit::init()
{
     if ( destination ==0)
	  return false;

     destination->init(slotName, &value);
     return true;
}


bool ARCSInit::init(QVariant var)
{
     if ( destination ==0)
	  return false;

     destination->init(slotName, &var);
     return true;
}

bool ARCSInit::init(ARCSAbstractComponent* cmp)
{
     if (destination == 0)
          return false;

     QVariant var = cmp->getGenuineComponentInstance();
     destination->init(slotName, &var);
     return true;
}


QString ARCSInit::getValueType()
{
     if (factory == 0)
	  factory = ARCSFactory::getInstance();
     
     return factory->getVariantType(value);
}

QString ARCSInit::getValueString()
{
     if (factory == 0)
	  factory = ARCSFactory::getInstance();

     return factory->dataSerialize(value);
}
