/*
  name: lib/arcsinternalfamily.cpp

  This file is part of ARCS - Augmented Reality Component System
  (version 2-current), written by Jean-Yves Didier 
  for IBISC Laboratory (http://www.ibisc.univ-evry.fr)

  Copyright (C) 2013  Universit d'Evry-Val d'Essonne

  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.


  Please send bugreports  with examples or suggestions to
  jean-yves.didier__at__ibisc.univ-evry.fr
*/


#include <arcs/arcsinternalfamily.h>

#include <arcs/arcscompositecomponent.h>
#include <arcs/arcscontrollercomponent.h>
#include <arcs/arcsapplicationcomponent.h>
#include <arcs/arcsscriptcomponent.h>

QString ARCSInternalFamily::name() const
{
     return "Internal";
}


void ARCSInternalFamily::destroy(ARCSAbstractComponent* cmp)
{
     QString type = cmp->getType();

     if (type == "Composite")
     {
          ARCSCompositeComponent* ccmp = dynamic_cast<ARCSCompositeComponent*>(cmp);
          if (ccmp)
               delete ccmp;
     }

     if (type == "StateMachine")
     {
          ARCSControllerComponent* ccmp = dynamic_cast<ARCSControllerComponent*>(cmp);
          if (ccmp)
               delete ccmp;
     }

     if (type == "Application")
     {
          ARCSApplicationComponent* ccmp = dynamic_cast<ARCSApplicationComponent*>(cmp);
          if (ccmp)
               delete ccmp;
     }

     if (type == "Script" )
     {
          ARCSScriptComponent* ccmp = dynamic_cast<ARCSScriptComponent*>(cmp);
          if (ccmp)
               delete ccmp;
     }
}


ARCSAbstractComponent* ARCSInternalFamily::instanciate(QString type)
{
     if (type == "Composite")
          return new ARCSCompositeComponent();

     if (type == "StateMachine")
          return new ARCSControllerComponent();

     if (type == "Application")
          return new ARCSApplicationComponent();

     if (type == "Script")
          return new ARCSScriptComponent();

     return 0;
}

void ARCSInternalFamily::removeFactory(QString)
{
}

bool ARCSInternalFamily::addFactory(QString, ARCSAbstractComponent* )
{
     return false;
}

QStringList ARCSInternalFamily::factoryList()
{
     QStringList lst;

     lst << "Application" << "StateMachine" << "Composite" << "Script" ;

     return lst;
}
