/*
  name: tests/factory/main.cpp

  This file is part of ARCS - Augmented Reality Component System
  (version 2-current), written by Jean-Yves Didier 
  for IBISC Laboratory (http://www.ibisc.univ-evry.fr)

  Copyright (C) 2013  Universit d'Evry-Val d'Essonne

  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.


  Please send bugreports  with examples or suggestions to
  jean-yves.didier__at__ibisc.univ-evry.fr
*/


#include <arcs/arcsfactory.h>
#include <QVariant>
#include <iostream>

int main()
{
    ARCSFactory* factory = ARCSFactory::getInstance();

    factory->loadLibrary("../../sample/sample");

    QStringList cmps  = factory->getComponentNames();

    for (int i = 0; i < cmps.count(); i++)
    {
        std::cout << qPrintable(cmps[i]) << std::endl;
    }

    ARCSAbstractComponent* b = factory->createComponent("Boucle");
    ARCSAbstractComponent* d = factory->createComponent("DisplayInt");

    if (b == 0)
    {
        std::cout << "b was not instanciated" << std::endl;  
        return 0;
    }
    if (d == 0)
    {
        std::cout << "d was not instanciated" << std::endl;
        return 0;
    }

    b->instanciate();
    d->instanciate();

    bool cnt = b->connect("newIteration(int)", d, "display(int)");
    if (cnt)
        std::cout << "Connection ralise" << std::endl;

    QVariant iteration=factory->dataDeserialize("int", "10");
    
    QStringList slts = b->getSlots();
    for (int k=0; k < slts.count(); k++)
    {
        std::cout << qPrintable(slts[k]) << std::endl;
    }

    bool ii = b->init("setIterations(int)", iteration); 

    if (ii)
        std::cout << "Initialisation russie" << std::endl;

    b->destroy();
    d->destroy();
    factory->destroyComponent(b);
    factory->destroyComponent(d);
    factory->unLoadLibrary("../../sample/sample");

    return 0;
}
