/*
  name: tools/editor/editcomponentwidget.cpp

  This file is part of ARCS - Augmented Reality Component System
  (version 2-current), written by Jean-Yves Didier 
  for IBISC Laboratory (http://www.ibisc.univ-evry.fr)

  Copyright (C) 2013  Universit d'Evry-Val d'Essonne

  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.


  Please send bugreports  with examples or suggestions to
  jean-yves.didier__at__ibisc.univ-evry.fr
*/


#include "editcomponentwidget.h"

#include <QVBoxLayout>
#include <QTextEdit>
#include <QLabel>
#include <QPushButton>
#include <QMessageBox>
#include <arcs/arcslog.h>
#include <QMenu>

EditComponentWidget::EditComponentWidget(ARCSAbstractComponent* aac, QWidget *parent) :
    QWidget(parent)
{
    //! \todo mettre  jour les proprits des composants gnres par le moteur dans la documentation.

    setWindowTitle("Component:" + aac->getProperty("id").toString());

    this->setLayout(new QVBoxLayout());

    component = aac;
    componentText = new QTextEdit(this);
    componentText->setAcceptRichText(false);
    layout()->addWidget(new QLabel("Textual representation"));
    layout()->addWidget(componentText);

    componentText->setText(aac->toString());
    componentRepresentation = aac->toString();

    validateButton = new QPushButton("Apply to component",this);
    layout()->addWidget(validateButton);

    connect(validateButton,SIGNAL(clicked()),this,SLOT(validate()));
    this->addActions(componentText->createStandardContextMenu()->actions());
}


void EditComponentWidget::validate()
{

    ARCSLog::getInstance()->startCapture();

    if ( component->parseString(componentText->toPlainText()))
    {
        QMessageBox::information(this,"Component content validation","The component textual representation has been validated.",QMessageBox::Ok);
        componentRepresentation = componentText->toPlainText();
    }
    else
    {
        QMessageBox::critical(this,"Component content validation","The component textual representation is not valid thus we are using the old one.");
        component->parseString(componentRepresentation);
        componentText->setText(componentRepresentation);
    }

    emit sendLog(ARCSLog::getInstance()->endCapture());
}

