/*
  name: tools/editor/graphicslinkitem.h

  This file is part of ARCS - Augmented Reality Component System
  (version 2-current), written by Jean-Yves Didier 
  for IBISC Laboratory (http://www.ibisc.univ-evry.fr)

  Copyright (C) 2013  Universit d'Evry-Val d'Essonne

  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.


  Please send bugreports  with examples or suggestions to
  jean-yves.didier__at__ibisc.univ-evry.fr
*/


#ifndef __GRAPHICSLINKITEM_H__
#define __GRAPHICSLINKITEM_H__

#include <QGraphicsPathItem>
#include <QGraphicsRectItem>
#include <QPen>
#include <arcs/arcsconnection.h>

class GraphicsPortItem;


class GraphicsGripLinkItem : public QGraphicsRectItem
{
public:
     GraphicsGripLinkItem(QGraphicsItem* parent);

     void setNext(GraphicsGripLinkItem* n) {next = n ; }
     void setPrevious(GraphicsGripLinkItem* p) { previous = p; }

protected:
     virtual void mouseMoveEvent(QGraphicsSceneMouseEvent *event);

private :
    GraphicsGripLinkItem* previous;
    GraphicsGripLinkItem* next;

};



class GraphicsLinkItem : public QGraphicsPathItem
{
public:
    GraphicsLinkItem(QGraphicsItem* parent,ARCSConnection* c = 0) ;
    ~GraphicsLinkItem();


    enum { Type = UserType + 3 };
    /*! A link can have three configurations :
     *  <code>
     *  --+        -+   +->   -+
     *    |         |   |      |
     *    +->    +--+   +------+
     *           |
     *           +->
     * </code>
     */

    enum Configuration
    {
            Step,
            S_Shape,
            Loop
    } ;

    int type() const
    {
         return Type;
    }


    ARCSConnection* getConnection() { return connection;}
    void setSource(GraphicsPortItem* s ) { source = s ; }
    void setDestination(GraphicsPortItem* d) { destination = d; }
    GraphicsPortItem* getSource() { return source; }
    GraphicsPortItem* getDestination() { return destination ; }
    void setCurrentPoint(QPointF p);
    void markForDeletion()  { markedForDeletion = true; }

    bool isFinalized() { return finalized;}
    void finalize(); // { finalized = true; }
    void connectGrips() ;
    void connectGrips(QPointF orig,QPointF dest) ;
    void redraw(bool isSource=true);

    virtual QPainterPath shape() const;

protected:
     virtual void hoverEnterEvent(QGraphicsSceneHoverEvent *);
     virtual void hoverLeaveEvent(QGraphicsSceneHoverEvent *);
     virtual void paint(QPainter *painter, const QStyleOptionGraphicsItem *option, QWidget *widget);

private:
    Configuration computeConfiguration(QPointF orig, QPointF dest);
    void computePath(QPointF orig, QPointF dest);
    GraphicsPortItem* source;
    GraphicsPortItem* destination;
    bool finalized;
    GraphicsGripLinkItem* grips[4];
    Configuration configuration;
    ARCSConnection* connection;
    QPen defaultPen;
    bool markedForDeletion;

};


#endif // __GRAPHICSLINKITEM_H__
