/*
  name: tools/editor/newcomponentdialog.cpp

  This file is part of ARCS - Augmented Reality Component System
  (version 2-current), written by Jean-Yves Didier 
  for IBISC Laboratory (http://www.ibisc.univ-evry.fr)

  Copyright (C) 2013  Universit d'Evry-Val d'Essonne

  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.


  Please send bugreports  with examples or suggestions to
  jean-yves.didier__at__ibisc.univ-evry.fr
*/


#include "newcomponentdialog.h"
#include <QLayout>

#include <QCompleter>
#include <QLabel>
#include <QLineEdit>
#include <QListWidget>
#include <QPushButton>
#include <QMessageBox>


NewComponentDialog::NewComponentDialog(ARCSContext* ctx, QWidget *parent) :
    QDialog(parent)
{
    context = ctx;

    this->setLayout(new QVBoxLayout());

    componentType = new QLineEdit(this);
    componentName = new QLineEdit(this);
    layout()->addWidget(new QLabel("Component types:"));
    layout()->addWidget(componentType);

    componentTypes = new QListWidget(this);
    componentTypes->addItems(ARCSFactory::getInstance()->getComponentNames());
    componentTypes->sortItems();
    layout()->addWidget(componentTypes);

    layout()->addWidget(new QLabel("Component name"));
    layout()->addWidget(componentName);

    QHBoxLayout* buttonLayout = new QHBoxLayout();
    ((QBoxLayout*)layout())->addLayout(buttonLayout);
    okButton = new QPushButton("Ok");
    cancelButton = new QPushButton("Cancel");
    buttonLayout->addWidget(okButton);
    buttonLayout->addWidget(cancelButton);

    QCompleter* cmpl = new QCompleter(ARCSFactory::getInstance()->getComponentNames(),this);
    cmpl->setCaseSensitivity(Qt::CaseInsensitive);
    componentType->setCompleter(cmpl);

    connect(okButton,SIGNAL(clicked()),this,SLOT(verify()));
    connect(cancelButton,SIGNAL(clicked()),this,SLOT(reject()));
    connect(componentType,SIGNAL(textChanged(QString)),this,SLOT(setType(QString)));
    connect(componentTypes,SIGNAL(currentTextChanged(QString)),componentType,SLOT(setText(QString)));
}


void NewComponentDialog::verify()
{
    if (componentTypes->selectedItems().isEmpty())
    {
        QMessageBox::critical(this,"Missing type","Component type is missing",QMessageBox::Ok);
        return ;
    }
    if (componentName->text().isEmpty() || context->getComponent(componentName->text()) )
    {
        QMessageBox::critical(this,"Invalid name","Your component name is either empty or already taken by another one.",QMessageBox::Ok);
        return;
    }

    accept();
}

void NewComponentDialog::setType(QString s)
{
    QList<QListWidgetItem*> results = componentTypes->findItems(s,Qt::MatchCaseSensitive);

    if (!results.isEmpty())
    {
        componentTypes->scrollToItem(results[0]);
        componentTypes->setCurrentItem(results[0]);
    }
}
