/*
  name: tools/editor/orderconnectionsdialog.cpp

  This file is part of ARCS - Augmented Reality Component System
  (version 2-current), written by Jean-Yves Didier 
  for IBISC Laboratory (http://www.ibisc.univ-evry.fr)

  Copyright (C) 2013  Universit d'Evry-Val d'Essonne

  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.


  Please send bugreports  with examples or suggestions to
  jean-yves.didier__at__ibisc.univ-evry.fr
*/


#include "orderconnectionsdialog.h"
#include <QTreeWidget>
#include <QTreeWidgetItem>

#include <QVBoxLayout>
#include <QHBoxLayout>
#include <QSpacerItem>
#include <QPushButton>

#include <iostream>


OrderConnectionsDialog::OrderConnectionsDialog(ARCSSheet* s, QWidget *parent) :
    QDialog(parent),sheet(s)
{
    QHBoxLayout* hl1 = new QHBoxLayout();
    QHBoxLayout* hl2 = new QHBoxLayout();
    QVBoxLayout* vl1 = new QVBoxLayout();
    QVBoxLayout* vl2 = new QVBoxLayout();

    setLayout(vl2);
    vl2->addLayout(hl1);
    vl2->addLayout(hl2);

    connectionTable = new QTreeWidget(this);
    connectionTable->setColumnCount(4);
    QStringList headerNames ;
    headerNames << "Source" << "Signal" << "Slot"  << "Destination" ;
    connectionTable->setHeaderLabels(headerNames);
    connectionTable->setRootIsDecorated(false);
    connectionTable->setSelectionMode(QAbstractItemView::SingleSelection);

    QStringList sources;
    QStringList destinations;
    QStringList sgnls;
    QStringList slts;

    sheet->getConnections(sources,sgnls,destinations,slts);
    //connectionTable->setRowCount(sources.count());
    int i;
    for (i=0; i< sources.count(); i++)
    {
        QStringList rowConnection;
        rowConnection << sources[i] << sgnls[i] << destinations[i] << slts[i];
        connectionTable->addTopLevelItem(new QTreeWidgetItem(rowConnection));
    }
    for (i=0; i< 4; i++)
        connectionTable->resizeColumnToContents(i);

    hl1->addWidget(connectionTable);
    hl1->addLayout(vl1);

    vl1->addStretch();
    QPushButton* upButton = new QPushButton("Move up", this);
    QPushButton* downButton = new QPushButton("Move down", this);

    vl1->addWidget(upButton);
    vl1->addWidget(downButton);
    vl1->addStretch();

    QPushButton* okButton = new QPushButton("Ok", this);
    QPushButton* cancelButton = new QPushButton("Cancel",this);

    hl2->addStretch();
    hl2->addWidget(okButton);
    hl2->addWidget(cancelButton);

    connect(upButton,SIGNAL(clicked()),this,SLOT(moveUp()));
    connect(downButton,SIGNAL(clicked()),this,SLOT(moveDown()));
    connect(okButton,SIGNAL(clicked()),this,SLOT(accept()));
    connect(cancelButton,SIGNAL(clicked()),this,SLOT(reject()));
}

void OrderConnectionsDialog::moveUp()
{
    int pos = connectionTable->indexOfTopLevelItem(connectionTable->currentItem());
    if (pos > 0)
    {
        permutations.append(QPair<int,int>(pos,pos-1));
        QTreeWidgetItem* qtwi = connectionTable->takeTopLevelItem(pos);
        connectionTable->insertTopLevelItem(pos-1,qtwi);
        connectionTable->setCurrentItem(qtwi);
    }
}

void OrderConnectionsDialog::moveDown()
{
    int pos = connectionTable->indexOfTopLevelItem(connectionTable->currentItem());
    if (pos < connectionTable->topLevelItemCount() - 1)
    {
        permutations.append(QPair<int,int>(pos,pos+1));
        QTreeWidgetItem* qtwi = connectionTable->takeTopLevelItem(pos);
        connectionTable->insertTopLevelItem(pos+1,qtwi);
        connectionTable->setCurrentItem(qtwi);
    }
}

void OrderConnectionsDialog::accept()
{
    for (int i=0; i< permutations.count(); i++)
        sheet->swapConnections(permutations[i].first,permutations[i].second);
    QDialog::accept();
}
