/*
  name: tools/editor/portdialog.h

  This file is part of ARCS - Augmented Reality Component System
  (version 2-current), written by Jean-Yves Didier 
  for IBISC Laboratory (http://www.ibisc.univ-evry.fr)

  Copyright (C) 2013  Universit d'Evry-Val d'Essonne

  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.


  Please send bugreports  with examples or suggestions to
  jean-yves.didier__at__ibisc.univ-evry.fr
*/


#ifndef __PORTDIALOG_H__
#define __PORTDIALOG_H__

#include <QDialog>
#include <QLineEdit>
#include <arcs/arcsabstractcomponent.h>


class PortDialog : public QDialog
{
Q_OBJECT

public:
    PortDialog (ARCSAbstractComponent* aac, bool slt,QWidget* parent=0); //: QDialog(parent)
    QString getPort() { return portNameEdit->text(); }

public slots:
    virtual void accept();


private:
    QString portName;
    QLineEdit* portNameEdit;
    QStringList portList;
};


#endif // __PORTDIALOG_H__
